% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{se}
\alias{se}
\title{Computes standard error of the mean.}
\usage{
se(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{A logical that indicates whether missing values should be removed before computing the standard error.}
}
\value{
A single numeric that is the standard error of the mean of \code{x}.
}
\description{
Computes the standard error of the mean (i.e., standard deviation divided by the square root of the sample size).
}
\examples{
x <- 1:20
sd(x)/sqrt(length(x))
se(x)

# all return NA if missing values are not removed
x2 <- c(x,NA)
sd(x2)/sqrt(length(x2))

# Better if missing values are removed
se(x2,na.rm=FALSE)
sd(x2,na.rm=TRUE)/sqrt(length(x2[complete.cases(x2)]))
se(x2)
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\seealso{
See \code{\link[sciplot]{se}} in \pkg{sciplot} for similar functionality.
}
\keyword{manip}

