#' @title Capture histories (4 samples) of a subset of Northern Pike from Buckthorn Marsh.
#' 
#' @description Capture histories (4 samples), in capture-by-date format, of a subset of Northern Pike from Buckthorn Marsh.
#' 
#' @details Each line consists of the date and unique fish identification number over four samples of northern pike (\emph{Esox lucius}) in Buckthorn Marsh.  This file contains the capture histories for only those pike captured from April 1-4.
#' 
#' @name PikeNYPartial2
#' 
#' @docType data
#' 
#' @format A data frame with 69 observations on the following 2 variables.
#'  \describe{
#'    \item{sample}{Name of the sample taken.} 
#'    \item{id}{Unique fish identification numbers.} 
#'  }
#'  
#' @section Topic(s):
#'  \itemize{
#'    \item Population size 
#'    \item Abundance 
#'    \item Mark-recapture 
#'    \item Schnabel method 
#'    \item Schumacher-Eschmeyer method 
#'    \item Capture history
#'  }
#'  
#' @concept Abundance 'Population Size' 'Mark-Recapture' 'Schnabel' 'Capture History'
#' 
#' @source New York Power Authority.  2004.  Use of buckhorn marsh and grand island tributaries by northern pike for spawning and as a nursery. Technical report, New York Power Authority, January 2004. Niagara Power Project (FERC No. 2216).
#' 
#' @keywords datasets
#' 
#' @examples
#' data(PikeNYPartial2)
#' str(PikeNYPartial2)
#' head(PikeNYPartial2)
#' 
NULL