% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSearch.R
\name{ts}
\alias{ts}
\title{Tabu Search}
\usage{
ts(data, class, featureSetEval, start = NULL, numNeigh = (ncol(data) -
  1), tamTabuList = 5, iter = 100, iterNoImprovement = NULL,
  intensification = NULL, iterIntensification = 50,
  interPercentaje = 75, tamIntermediateMemory = 5,
  diversification = NULL, iterDiversification = 50,
  forgetTabuList = TRUE, verbose = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{start}{\itemize{
\item Binary vector with the set of initial features
}}

\item{numNeigh}{\itemize{
\item The number of neighbor to consider in each iteration. By default: all posibles. It is important to note that a high value of this parameter considerably increases the computation time.
}}

\item{tamTabuList}{\itemize{
\item The size of the tabu list. By default: 5
}}

\item{iter}{\itemize{
\item The number of iterations of the algorithm. By default: 100
}}

\item{iterNoImprovement}{\itemize{
\item Number of iterations without improvement to start/reset the intensification/diversification phase. By default, it is not taken into account (all iterations are performed)
}}

\item{intensification}{\itemize{
\item Number of times the intensification phase is applied. None by default
}}

\item{iterIntensification}{\itemize{
\item Number of iterations of the intensification phase
}}

\item{interPercentaje}{\itemize{
\item Percentage of the most significant features to be taken into account in the intensification phase
}}

\item{tamIntermediateMemory}{\itemize{
\item Number of best solutions saved in the intermediate memory
}}

\item{diversification}{\itemize{
\item Number of times the diversification phase is applied. None by default
}}

\item{iterDiversification}{\itemize{
\item Number of iterations of the diversification phase
}}

\item{forgetTabuList}{\itemize{
\item Forget tabu list for intensification/diversification phases. By default: TRUE
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration
}}
}
\value{
A list is returned containing for each repetition of the algorithm:
}
\description{
The Tabu Search\insertCite{glover1986}{FSinR} \insertCite{glover1990}{FSinR} method starts with a certain set of features and in each iteration it searches among its neighbors to advance towards a better solution. The method has a memory (tabu list) that prevents returning to recently visited neighbors. The method ends when a certain number of iterations are performed, or when a certain number of iterations are performed without improvement, or when there are no possible neighbors. Once the method is finished, an intensification phase can be carried out that begins in the space of the best solutions found, or a diversification phase can be carried out in which solutions not previously visited are explored.
}
\examples{
## Taboo-Search algorithm for iris dataset (filter method)
ts(iris, 'Species', roughsetConsistency, iter = 5)
}
\references{
\insertAllCited{}
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{basicStage}{List containing the best neighbour in each iteration along with its obtained evaluation measure, and the content of the taboo list in each iteration}
\item{intensificationStage}{List containing for each repetition of the intensification phase the best neighbour in each iteration along with its obtained evaluation measure, and the content of the taboo list in each iteration.}
\item{diversificationStage}{List containing for each repetition of the diversification phase the best neighbour in each iteration along with its obtained evaluation measure, and the content of the taboo list in each iteration.}
}
}
\author{
Francisco Aragón Royón
}
