\name{plot.simfam_c}
\alias{plot.simfam_c}
\title{Plot method for \code{simfam_c} or Plot pedigrees}
\description{
Provides pedigree plots for specified families generated from \code{simfam_c} function with option to save plots into a pdf file.
}
\usage{
\method{plot}{simfam_c}(x, famid, pdf = FALSE, file = NULL, \ldots)
}
\arguments{
 \item{x}{An object of class \code{'simfam'} created by \code{\link{simfam}} function or a data frame that has class attributes \code{c("simfam", "data.frame")}.
}
 \item{famid}{List of family IDs to plot. Default is the first family in given data set.}
 \item{pdf}{Logical; if \code{TRUE}, pedigree plots are saved in a pdf file. If \code{FALSE}, plot pedigrees on current plotting device. Default is \code{FALSE}.}
 \item{file}{File name to save the pedigree plots; Default file name is \code{"pedigreeplot.pdf"}.}
 \item{...}{Additional arguments passed on to the plot function.}
 
}

\details{
Argument \code{x} can be a data frame that contains \code{famID}, \code{indID}, \code{fatherID},  \code{motherID}, \code{gender} (1 for male, 0 for female), \code{status} (1 for affected by event 1, 2 for affected by event 2, 0 for non-affected), \code{mgene} (1 for mutation carrier, 0 for non-carrier, \code{NA} for missing), and \code{proband} (1 for proband, 0 for non-proband) and should have class attributes \code{class(x) <- c("simfam", "data.frame")}.

Optionally, the data frame can contain a column named \code{carrp.geno} or \code{carrp.pheno} to replace missing values in \code{mgene} with their carrier probabilities.
}

\value{
Returns pedigree plots for specified families created by \code{\link{simfam_c}} function or for the data frame provided along with the affection and carrier mutation statuses of family members. Probands from each pedigree are indicated using red color.

When object inlcudes \code{carrp.geno} and/or \code{carrp.pheno} generated by \code{\link{carrierprob}} function, the \code{plot} function displays the carrier probabilities for those with missing carrier status.
}


\seealso{
\code{\link{simfam}, \link{summary.simfam}, \link{carrierprob}}	
}

\examples{

# Simulated competing risk data from gamma frailty model based on pop+ design

set.seed(4321)
fam <- simfam_c(N.fam = 10, design = "pop+", variation = "frailty", competing=TRUE,
                  base.dist = "Weibull", frailty.dist = "gamma", depend=c(2, 2), 
                  allelefreq = 0.02, base.parms = list(c(0.01, 3), c(0.01, 3)), 
                  vbeta = list(c(-1.13, 2.35),c(-1, 2)))

# Pedigree plots for first three simulated families

plot(fam, famid = 1)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Pedigree plot }
