% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_funcs.R
\name{farm.select}
\alias{farm.select}
\title{Factor-adjusted robust model selection}
\usage{
farm.select(Y, X, loss = c("mcp", "scad", "lasso"), verbose = TRUE,
  robust = FALSE, ...)
}
\arguments{
\item{Y}{a size n outcome vector.}

\item{X}{an n x p covariate matrix with each row being a sample. Must have same number of rows as the size of \code{Y}.}

\item{loss}{an \emph{optional} character string specifying the loss function to be minimized. Must be one of "mcp" (default), "scad" or "lasso". You can just specify the initial letter.}

\item{verbose}{an \emph{optional} boolean determining whether or not to print output to the console. Default is TRUE.}

\item{robust}{an \emph{optional} boolean, specifying whether or not to use robust estimators for mean and variance. Default is FALSE.}

\item{\dots}{Arguments passed to the \code{\link{farm.adjust}} function.}
}
\value{
A list with the following items
\item{beta.chosen}{the indices of the covariates chosen in the model}
\item{coef.chosen}{the coefficients of the chosen covariates}
\item{X.res}{the decorrelated covariate matrix}
\item{Y.res}{the response vector corresponding to the decorrelated covariates}
\item{nfactors}{number of (estimated) factors}
}
\description{
Given a covariate matrix and output vector, this function first adjusts the covariates for underlying factors and then performs model selection.
}
\details{
Number of rows and columns of the covariate matrix must be at least 4 in order to be able to calculate latent factors.

For details about the method, see Fan et al.(2017).

For formula of how the covariates and the repsonse vector are  adjusted for latent factors, see Section 3.2 in Fan et al.(2017).
}
\examples{
set.seed(100)
P = 100 #dimension
N = 50 #samples
K = 3 #nfactors
Q = 5 #model size
Lambda = matrix(rnorm(P*K, 0,1), P,K)
F = matrix(rnorm(N*K, 0,1), N,K)
U = matrix(rnorm(P*N, 0,1), P,N)
X = Lambda\%*\%t(F)+U
X = t(X)
beta_1 = 3+3*runif(Q)
beta = c(beta_1, rep(0,P-Q))
eps = rnorm(N)
Y = X\%*\%beta+eps
output = farm.select(Y,X)
}
\references{
Fan J., Ke Y., Wang K., "Decorrelation of Covariates for High Dimensional Sparse Regression." \url{https://arxiv.org/abs/1612.08490}
}
