% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_trigohp.R
\name{loghp}
\alias{loghp}
\alias{acoshp}
\alias{asinhp}
\alias{atanhp}
\alias{asechp}
\alias{acosechp}
\alias{acotanhp}
\title{Inverse Power Hyperbolas and Inverse Power Hyperbolic Functions}
\usage{
loghp(x, k = 1)

acoshp(x, k = 1)

asinhp(x, k = 1)

atanhp(x, k = 1)

asechp(x, k = 1)

acosechp(x, k = 1)

acotanhp(x, k = 1)
}
\arguments{
\item{x}{a numeric value, vector or matrix.}

\item{k}{a numeric value, preferably strictly positive.}
}
\description{
The inverse power hyperbolas and the inverse power hyperbolic functions: 
arc-cosine-hp, arc-sine-hp, arc-tangent-hp, 
arc-secant-hp, arc-cosecant-hp and arc-cotangent-hp.
}
\details{
\code{loghp} function is defined on (0, +Inf) by: 
      \deqn{  logshp(x, k) = 2 * k * sinh( log(x) / k) }
\code{acoshp} function is defined on [1, +Inf) by: 
      \deqn{ acoshp(x, k) = 2 * k * sinh( acosh(x) / k) }
\code{asinhp} function is defined on (-Inf, +Inf) by: 
      \deqn{ asinhp(x, k) = 2 * k * sinh( asinh(x) / k) }
\code{atanhp} function is defined on (-1, +1) by: 
      \deqn{ atanhp(x, k) = 2 * k * sinh( atanh(x) / k) }
\code{asechp} function is defined on (0, +1] by: 
      \deqn{ asechp(x, k) = 2 * k * sinh( acosh(1/x) / k) }
\code{acosechp} function is defined on (-Inf, 0) U (0, +Inf) by: 
    \deqn{ acosechp(x, k) = 2 * k * sinh( asinh(1/x) / k) }
\code{acotanhp} function is defined on (-Inf, -1) U (1, +Inf) by: 
    \deqn{ acotanhp(x, k) = 2 * k * sinh( atanh(1/x) / k) }

If k is a vector of length > 1, then the use of the function 
\code{\link[base]{outer}} is recommanded.
}
\examples{

### Example 1 (acoshp, asinhp, atanhp)
 loghp( c(ppoints(10), 1, 1/rev(ppoints(10))), k = 2)
acoshp( 1:10, k = 2)
asinhp( -5:5, k = 2)
atanhp( seq(-1, 1, by = 0.1), k = 2)
asechp( ppoints(20), k = 2)
acosechp( -5:5, k = 2)
acotanhp( c( -1/ppoints(10), 1/rev(ppoints(10))), k = 2)

x  <- (-3:3)*3 
 loghp(exphp(x, k = 4), k = 4)
acoshp(coshp(x, k = 4), k = 4)
asinhp(sinhp(x, k = 4), k = 4)
atanhp(tanhp(x, k = 4), k = 4)


### Example 2 (loghp, acoshp, asinhp, atanhp)
k     <- c(0.6, 1, 1.5, 2, 3.2, 10) ; names(k) <- k
olty  <- c(2, 1, 2, 1, 2, 1, 1)
olwd  <- c(1, 1, 2, 2, 3, 4, 2)
ocol  <- c(2, 2, 4, 4, 3, 3, 1)
op    <- par(mfrow = c(2, 2), mgp = c(1.5, 0.8, 0), mar = c(3, 3, 2, 1))

xld     <- 0.05
xl      <- seq(0.05, 20, xld) ; names(xl) <- xl
Tlcoshp <- ts(cbind(outer(xl, k, loghp), "2*log(x)" = 2*log(xl)), 
              start = xl[1], deltat = xld)
plot(Tlcoshp, plot.type = "single", xlim = c(0,20), ylim = c(-5,15), 
     lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i", 
     xlab="", ylab = "", main = "loghp(x, k)" )
legend("bottomright", title = expression(kappa), legend = colnames(Tlcoshp), 
     inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

## acoshp(x, k)
xcd     <- 0.5
xc      <- seq(1, 20, xcd) ; names(xc) <- xc
Tacoshp <- ts(cbind(outer(xc, k, acoshp), "2*acosh(x)" = 2*acosh(xc)), 
              start = xc[1], deltat = xcd)
plot(Tacoshp, plot.type = "single", ylim = c(0,15), lty = olty, lwd = olwd, col = ocol,
        xaxs = "i", yaxs = "i", xlab = "", ylab = "", main = "acoshp(x, k)" )
legend("bottomright", title = expression(kappa), legend = colnames(Tacoshp), 
        inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

## asinhp(x, k)
xsd     <- 0.5
xs      <- seq(-10, 10, xsd) ; names(xs) <- xs
Tasinhp <- ts(cbind(outer(xs, k, asinhp), "2*asinh(x)" = 2*asinh(xs)), 
              start = xs[1], deltat = xsd)
plot(Tasinhp, plot.type = "single", ylim = c(-10,10), lty = olty, lwd = olwd, col = ocol,
        xaxs = "i", yaxs = "i", xlab = "", ylab = "", main = "asinhp(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Tasinhp), 
        inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

## atanhp(x, k)
xtd     <- 0.01
xt      <- seq(-1, 1, xtd) ; names(xt) <- xt
Tatanhp <- ts(cbind(outer(xt, k, atanhp), "2*atanh(x)" = 2*atanh(xt)), 
              start = xt[1], deltat = xtd)
plot(Tatanhp, plot.type = "single", ylim = c(-10,10), lty = olty, lwd = olwd, col = ocol,
        xaxs = "i", yaxs = "i", xlab = "", ylab = "", main = "atanhp(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Tatanhp), 
        inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )
### End Example 2


}
\seealso{
The power hyperbolic functions \code{\link{exphp}}.
}
