% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ITRDB_FUNCTIONS.R
\name{read.crn}
\alias{read.crn}
\title{Read a Tucson-format chronology file.}
\usage{
read.crn(file)
}
\arguments{
\item{file}{A character string path pointing to a \code{*.crn} file to be read.}
}
\value{
A list containing the metadata and chronology.
}
\description{
This function includes improvements to the \code{\link{read.crn}} function from the
\pkg{dplR} library. The principle changes are better parsing of metadata, and support
for the Schweingruber-type Tucson format. Chronologies that are unable to be read
are reported to the user. This function automatically recognizes Schweingruber-type files.
}
\details{
This wraps two other functions: \code{\link{read.crn.metadata}} \code{\link{read.crn.data}}.
}

