% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLCD_FUNCTIONS.R
\name{pal_nlcd}
\alias{pal_nlcd}
\title{NLCD colour map palettes}
\usage{
pal_nlcd()
}
\value{
A data frame with official class descriptions and hexencoded rgb(a) colour values
}
\description{
NLCD colour map palettes
}
\examples{
\dontrun{
# Extract data for the Village Ecodynamics Project 'VEPIIN' study area:
# http://village.anth.wsu.edu
vepPolygon <- polygon_from_extent(raster::extent(672800,740000,4102000,4170000), 
     proj4string='+proj=utm +datum=NAD83 +zone=12')

NLCD <- get_nlcd(template=vepPolygon, label='VEPIIN')
NLCD <- as.matrix(table(raster::values(NLCD)))
cols <- dplyr::filter(pal_nlcd(), code \%in\% row.names(NLCD))
par(xpd = TRUE, mar = c(10, 3, 2, 1))
barplot(NLCD, beside = FALSE, col = cols$color) 
legend("bottom", legend = cols$description, fill = cols$color, 
       ncol = 2, inset = c(0, -0.6))
}
}
\references{
\url{https://www.mrlc.gov/data/legends/national-land-cover-database-2011-nlcd2011-legend}
}
