% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAYMET_FUNCTIONS.R
\name{download_daymet_thredds}
\alias{download_daymet_thredds}
\title{Download the 1-km DAYMET daily weather dataset for a region as a netcdf.}
\usage{
download_daymet_thredds(bbox, element, year, region, tempo)
}
\arguments{
\item{bbox}{the bounding box in WGS84 coordinates as a comma-separated character vector
"xmin,ymin,xmax,ymax"}

\item{element}{An element to extract.\cr
The available elements are:\cr
dayl = Duration of the daylight period in seconds per day. This calculation is based on the period of the day during which the sun is above a hypothetical flat horizon.\cr
prcp = Daily total precipitation in millimeters per day, sum of all forms converted to water-equivalent. Precipitation occurrence on any given day may be ascertained.\cr
srad = Incident shortwave radiation flux density in watts per square meter, taken as an average over the daylight period of the day. NOTE: Daily total radiation (MJ/m2/day) can be calculated as follows: ((srad (W/m2) * dayl (s/day)) / l,000,000)\cr
swe = Snow water equivalent in kilograms per square meter. The amount of water contained within the snowpack.\cr
tmax = Daily maximum 2-meter air temperature in degrees Celsius.\cr
tmin = Daily minimum 2-meter air temperature in degrees Celsius.\cr
vp = Water vapor pressure in pascals. Daily average partial pressure of water vapor.\cr}

\item{year}{An integer year to extract.}

\item{region}{The name of a region. The available regions are:\cr
na = North America\cr
hi = Hawaii\cr
pr = Puerto Rico\cr}

\item{tempo}{The frequency of the data. The available tempos are:\cr
day = Daily data\cr
mon = Monthly summary data\cr
ann = Annual summary data\cr}
}
\value{
A named list of character vectors, each representing the full local paths of the tile downloads.
}
\description{
Data are downloaded in the NetCDF format. \code{download_daymet_thredds} returns the path to the downloaded NetCDF file.
}
\keyword{internal}
