% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_both.R
\name{FF.naive.both}
\alias{FF.naive.both}
\title{Create a complete naive-valued firm-firm (FF) matrix}
\usage{
FF.naive.both(
  ...,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE,
  combining = "sum"
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}

\item{combining}{How to combine the FF matrix for managers and that for owners. Possible values:
 \itemize{
 \item \code{sum};
 \item \code{mean} or \code{average};
 \item \code{min};
 \item \code{max};
}}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a naive-valued firm-firm (FF) matrix based on both common ownership and board interlocks
}
\details{
The ties' value will reflect the count of common owners and membership depending on \code{combining}:
\itemize{
 \item \code{sum}: sum of the counts;
 \item \code{mean} or \code{average}: average of the counts;
 \item \code{min}: minimum of the counts;
 \item \code{max}: maximum of the counts.
}
}
\examples{

# Create the complete naive firm-firm matrix for the companies held by Berkshire Hathaway
data('firms_BKB')
FF <- FF.naive.both(firms_BKB)

}
\seealso{
\link{FF} \link{FF.binary.both} \link{FF.norm.both}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
