% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct.meas.R
\name{correct.meas}
\alias{correct.meas}
\title{Correction of Metabolic Rate Measurements}
\usage{
correct.meas(info.data, pre.data, post.data, meas.data,
             method = c("pre.test", "post.test", "average",
                        "progressive", "parallel"),
             empty.chamber = c("CH1", "CH2", "CH3", "CH4",
                               "CH5", "CH6", "CH7", "CH8"))
}
\arguments{
\item{info.data}{a data frame obtained by using the function
\code{\link{input.info}}}
\item{pre.data}{a data frame obtained by using the function \code{\link{import.test}} for "pre.test" method}
\item{post.data}{a data frame obtained by using the function \code{\link{import.test}} for "post.test" method}
\item{meas.data}{a data frame obtained by using the function \code{\link{import.meas}}}
\item{method}{string: the name of the method used for background respiration correction:
\itemize{
\item  "pre.test" - substracts oxygen consumption of pre.data from oxygen consumptions of meas.data
\item  "post.test" - substracts oxygen consumption of post.data from oxygen consumptions of meas.data
\item  "average" - substracts an averaged oxygen consumption of pre.data and post.data from oxygen consumptions of meas.data
\item  "progressive" - substracts a vector of progressively changing microbial consumptions from oxygen consumptions of meas.data. The values of oxygen consumption are linearly predicted from two reference points: oxygen consumption of pre.data and oxygen consumption of post.data. The number of elements in the vector equals to the total number of periods in metabolic rate measurements.
\item  "parallel" - substracts oxygen consumption in an empty chamber from oxygen consumptions of meas.data for each chamber
}}
\item{empty.chamber}{string: the name of an empty chamber used only for the method 'parallel'}
}
\value{
The function returns a data frame containing data of metabolic
rate measurements corrected for background respiration. The data frame
is used in the functions \code{\link{QC.meas}}, \code{\link{QC.activity}},
\code{\link{extract.slope}} and \code{\link{QC.slope}}.
}
\description{
The function is used to correct metabolic rate measurements
for background respiration. To this end, oxygen consumption
is estimated as the slope of the linear regression of measured
O2 concentration over time, and is extracted for background
respiration test and for each period of actual measurements.
The correction is based on substraction of oxygen consumption
obtained during background respiration test from oxygen
consumption obtained during metabolic rate measurements.
}
\examples{
# if the data have been already loaded to R,
# skip the first six lines of the code:
setwd(path.package("FishResp", quiet = FALSE))
load("data/info.RData")
load("data/pre.RData")
load("data/post.RData")
load("data/SMR.raw.RData")
load("data/AMR.raw.RData")

SMR.clean <- correct.meas(info.data = info,
                          pre.data = pre,
                          meas.data = SMR.raw,
                          method = "pre.test")

AMR.clean <- correct.meas(info.data = info,
                          post.data = post,
                          meas.data = AMR.raw,
                          method = "post.test")

}
\references{
{ Svendsen, M. B. S., P. G. Bushnell, and J. F. Steffensen. 2016.
Design and setup of intermittent-flow respirometry system for aquatic organisms. J. Fish Biol. 88: 26-50.}
}
