% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcR.R
\name{calcR}
\alias{calcR}
\title{Compute numerator relationship coefficients between two distinct groups of individuals}
\usage{
calcR(ped, set1, set2, type = "notdam-notsire")
}
\arguments{
\item{ped}{: A data frame with integer columns corresponding to ID, SIRE, and DAM. IDs should be sequential, starting from 1. Missing parents (SIRE and DAM) are denoted as 0.}

\item{set1}{: A set of individual IDs.}

\item{set2}{: A set of individual IDs, distinct from \code{set1}.}

\item{type}{: \code{"notdam-notsire"} (default), \code{"sire-sire"}, or \code{"dam-dam"} relationships
\describe{
\item{\code{"notdam-notsire"}}{requires \code{set1} and \code{set2} individuals not to be members of \code{ped$DAM} and \code{ped$SIRE}, respectively.}
\item{\code{"sire-sire"}}{requires \code{set1} and \code{set2} individuals to be members of \code{ped$SIRE}.}
\item{\code{"dam-dam"}}{requires \code{set1} and \code{set2} individuals to be members of \code{ped$DAM}.}
}}
}
\value{
: Numerator relationship coefficients between \code{set1} and \code{set2} individuals in the form of a matrix (a partition of the numerator relationship matrix \bold{A}).
}
\description{
Compute numerator relationship coefficients between two distinct groups of individuals
}
\examples{
# A sample pedigree data frame:
ped <- data.frame(
    ID = 1:12,
    SIRE = c(0, 0, 0, 2, 2, 0, 4, 6, 0, 6, 10, 10),
    DAM = c(0, 0, 0, 1, 1, 0, 3, 5, 7, 8, 9, 0)
)

# Example 1: Calculate relationship coefficients between two groups of animals,
# one's members not among dams, and the members of the other not among sires.
calcR(ped, set1 = c(12, 6), set2 = c(11, 8), type = "notdam-notsire")
# Since `"notdam-notsire"` is the default type, `type = "notdam-notsire"` might be omitted.

# Example 2: Calculate relationship coefficients between dam 7 and dams 8 and 9.
calcR(ped, set1 = 7, set2 = 8:9, type = "dam-dam")

# Example 3: Calculate relationship coefficients between sires 2 & 6 and sires 4 & 10.
calcR(ped, set1 = c(2, 6), set2 = c(4, 10), type = "sire-sire")

}
