% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcsrec.R
\name{tcsrec}
\alias{tcsrec}
\title{Heuristic first-temporal-then-cross-sectional cross-temporal forecast reconciliation}
\usage{
tcsrec(basef, thf_comb, hts_comb, res, avg = "KA", ...)
}
\arguments{
\item{basef}{(\mjseqn{n \times h(k^\ast+m)}) matrix of base forecasts to be
reconciled, \mjseqn{\widehat{\mathbf{Y}}}; \mjseqn{n} is the total number of variables,
\mjseqn{m} is the highest time frequency, \mjseqn{k^\ast} is the sum of (a
subset of) (\mjseqn{p-1}) factors of \mjseqn{m}, excluding \mjseqn{m}, and
\mjseqn{h} is the forecast horizon for the lowest frequency time series.
Each row identifies a time series, and the forecasts are ordered as
[lowest_freq' ...  highest_freq']'.}

\item{hts_comb, thf_comb}{Type of covariance matrix (respectively
(\mjseqn{n \times n}) and (\mjseqn{(k^\ast + m) \times (k^\ast + m)})) to
be used in the cross-sectional and temporal reconciliation, see more in
\code{comb} param of \code{\link[FoReco]{htsrec}()} and
\code{\link[FoReco]{thfrec}()}.}

\item{res}{(\mjseqn{n \times N(k^\ast + m)}) matrix containing the residuals
at all the temporal frequencies ordered [lowest_freq' ...  highest_freq']'
(columns) for each variable (row), needed to estimate the covariance matrix
when \code{hts_comb =} \code{\{"wls",} \code{"shr",} \code{"sam"\}} and/or
\code{hts_comb =} \code{\{"wlsv",} \code{"wlsh",} \code{"acov",}
\code{"strar1",} \code{"sar1",} \code{"har1",} \code{"shr",} \code{"sam"\}}.
The row must be in the same order as \code{basef}.}

\item{avg}{If \code{avg = "KA"} (\emph{default}), the final projection
matrix \mjseqn{\mathbf{M}} is the one proposed by Kourentzes and
Athanasopoulos (2019), otherwise it is calculated as simple average of
all the involved projection matrices at step 2 of the procedure (see
Di Fonzo and Girolimetto, 2020).}

\item{...}{any other options useful for \code{\link[FoReco]{htsrec}()} and
\code{\link[FoReco]{thfrec}()}, e.g. \code{m}, \code{C} (or \code{Ut} and
\code{nb}), \code{nn} (for non negativity reconciliation only at first step),
\code{mse}, \code{corpcor}, \code{type}, \code{sol}, \code{settings},
\code{W}, \code{Omega},...}
}
\value{
The function returns a list with two elements:
\item{\code{recf}}{(\mjseqn{n \times h(k^\ast + m)}) reconciled forecasts matrix, \mjseqn{\widetilde{\textbf{Y}}}.}
\item{\code{M}}{Matrix which transforms the uni-dimensional reconciled forecasts of step 1 (projection approach) .}
}
\description{
\loadmathjax
The cross-temporal forecast reconciliation procedure by
Kourentzes and Athanasopoulos (2019) can be viewed as an ensemble
forecasting procedure which exploits the simple averaging of different
forecasts. First, for each time series the forecasts at any temporal
aggregation order are reconciled using temporal hierarchies
(\code{\link[FoReco]{thfrec}()}), then time-by-time cross-sectional
reconciliation is performed (\code{\link[FoReco]{htsrec}()}). The
projection matrices obtained at this step are then averaged and used to
cross-sectionally reconcile the forecasts obtained at step 1, by this way
fulfilling both cross-sectional and temporal constraints.
}
\details{
This function performs a two-step cross-temporal forecast reconciliation using
the covariance matrices chosen by the user. If the combinations used by Kourentzes and Athanasopoulos (2019) are
wished, \code{thf_comb} must be set equal to either \code{"struc"} or \code{"wlsv"},
and \code{hts_comb} equal to either \code{"shr"} or \code{"wls"}.

\strong{Warning},
the two-step heuristic reconciliation allows non negativity constraints only in the first step.
This means that non-negativity is not guaranteed in the final reconciled values.
}
\examples{
data(FoReco_data)
obj <- tcsrec(FoReco_data$base, m = 12, C = FoReco_data$C,
              thf_comb = "acov", hts_comb = "shr", res = FoReco_data$res)

}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.

Kourentzes, N., Athanasopoulos, G. (2019), Cross-temporal coherent forecasts
for Australian tourism, \emph{Annals of Tourism Research}, 75, 393-409.

\enc{Schäfer}{Schafer}, J.L., Opgen-Rhein, R., Zuber, V., Ahdesmaki, M.,
Duarte Silva, A.P., Strimmer, K. (2017), \emph{Package `corpcor'}, R
package version 1.6.9 (April 1, 2017), \href{https://CRAN.R-project.org/package=corpcor}{https://CRAN.R-project.org/package= corpcor}.

\enc{Schäfer}{Schafer}, J.L., Strimmer, K. (2005), A Shrinkage Approach to Large-Scale Covariance
Matrix Estimation and Implications for Functional Genomics, \emph{Statistical
Applications in Genetics and Molecular Biology}, 4, 1.

Stellato, B., Banjac, G., Goulart, P., Bemporad, A., Boyd, S. (2020). OSQP:
An Operator Splitting Solver for Quadratic Programs, \emph{Mathematical Programming Computation},
12, 4, 637-672.

Stellato, B., Banjac, G., Goulart, P., Boyd, S., Anderson, E. (2019), OSQP:
Quadratic Programming Solver using the `OSQP' Library, R package version 0.6.0.3
(October 10, 2019), \href{https://CRAN.R-project.org/package=osqp}{https://CRAN.R-project.org/package=osqp}.
}
\seealso{
Other reconciliation procedures: 
\code{\link{cstrec}()},
\code{\link{ctbu}()},
\code{\link{htsrec}()},
\code{\link{iterec}()},
\code{\link{lccrec}()},
\code{\link{octrec}()},
\code{\link{tdrec}()},
\code{\link{thfrec}()}
}
\concept{reconciliation procedures}
\keyword{heuristic}
