% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecursiveForecastModel

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{RecursiveForecastModel}
\alias{RecursiveForecastModel}
\title{RecursiveForecastModel}
\description{A model for recursively predicting multiple timesteps into the future.  This class implements a particular type of forecasting, where a predict method is called to predict each successive time step in order. Extend this class if you have a predict method, but not a special forecast method.}
\seealso{
Inherits from : \code{\link{ForecastModel}}

Is inherited by : \code{\link{MoveAheadModel}}}
\examples{
MoveAheadModel <- R6Class(
  classname = 'MoveAheadModel',
  inherit = RecursiveForecastModel,
  private = list(
    .data = IncidenceMatrix$new(),
    newdata = IncidenceMatrix$new(),
    output = ArrayData$new(),
  	.nsim = 3,
    .predCols = c(as.integer(1)),
    .maxPredCol = as.integer(1)
  ),
  public = list(
    initialize = function(nsim = 3)\{
      private$.nsim = nsim
    \},
    fit_ = function()\{
      if(self$data$ncol <= self$predCols)\{
        stop("We cannot go further back than the start of the matrix.")
      \}
    \},
    predictRow_ = function(row,col=0)\{
      predict_(col)
    \},
    predict_ = function(col=0)\{
      if('predict_' \%in\% private$.debug)\{
        browser()
      \}
      if(col == 0)\{
        col=1:private$output$ncol
      \}
      private$output$mutate(
        cols=col,
        data = SimulatedIncidenceMatrix$new(
          private$newdata,
          private$.nsim
        )$simulations
      )
    \},
    prepareFitData = function(data)\{
      private$.data = data$clone(TRUE)
    \},
    preparePredictData = function(newdata)\{
      if('preparePredictData' \%in\% private$.debug)\{
        browser()
      \}
      private$newdata = SimulatedIncidenceMatrix$new(data=newdata,nsim=self$nsim)
      private$.nrow = private$newdata$nrow
      private$newdata$addColumns(min(self$predCols))
      private$newdata$lag(min(self$predCols),na.rm=FALSE)
      private$newdata$subset(cols=2:private$newdata$ncol)
    \},
    prepareForecastData = function(data)\{
      if(self$data$ncol <= self$predCols)\{
        stop("We cannot go further back than the start of the matrix.")
      \}
      private$newdata = data$clone(TRUE)
      private$.nrow = private$newdata$nrow
      private$newdata$addColumns(min(self$predCols))
      private$newdata$lag(min(self$predCols),na.rm=TRUE)
    \},
    prepareOutputData = function(inputData,steps=0)\{
      private$output = SimulatedIncidenceMatrix$new(inputData,private$.nsim)
      if(steps > 0)\{
        private$output$addColumns(steps)
      \}
    \}
  ),
  active = list(
    nsim = function(value)\{
      private$defaultActive(type='private',name='.nsim',val=value)
    \}
  )
)
}
\section{Fields}{
\describe{
\item{data}{A MatrixData containing the data used in fitting of the model.}
\item{maxPredCol}{The farthest back column from the output value used in prediction.}
\item{predCols}{An array of which columns are used in prediction.  1 means the column before the prediction, 2 the one before that etc.}
}}
\section{Methods}{
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{fit(data)}{
Fit the model for predicting.  This method breaks down the fitting  process into two parts, data preparation, and the model fitting.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to use to fit the model.  This object should be a  MatrixData object.}
}}}}
\methodname{fit_()}{
This method \bold{must} be extended.  Fit the model for predicting all of the rows. Assumes the data has been  put into place.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}}}
\methodname{forecast(newdata,steps=1,stochastic='Poisson',nsims=self$nsim,addToData = FALSE)}{
Using a model previously fit with \code{fit} to predict the next \code{steps} columns.  This function assumes that all of the data preprocessing has already been taken care of.  This function is similar to predict, except that it can predict multiple time steps into the future instead of a single timestep.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{The data to forecast from.}
\methoditem{steps}{The number of timesteps into the future to predict.}
\methoditem{stochastic}{Treat the data as though drawn from a random  distribution, and recover the true value.  Can be used to calculate  confidence intervals, and investigate model sensitivity.}
\methoditem{nsims}{The number of simulations to do if stochastic.}
\methoditem{addToData}{Whether or not to mutate the data to incorporate the new predictions.}
}}
\item{Value}{private$output This function should both modify and return private$output.}
}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{predict(newdata)}{
Use a model previously fit with fit to predict. This function does not assume any data preprocessing.  This function should not, in general need  to be overwritten by the user.  The main prediction function is predict_, so please modify that function instead if possible.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{Optional.  The data used to predict.  This data should be a MatrixData object.}
}}}}
\methodname{predictRow(newdata,row,col)}{
Using a model previously fit with \code{fitRow} to predict the  \code{row}th row of the next column. This function does not assume any data preprocessing.  Since the predict method predicts every row at the  the same time, we include this method for predicting only a single row.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{Optional.  The data use to predict.  This can either be a matrix, appropriately formatted lag vector, or NULL to predict based on the data used to fit.}
\methoditem{row}{The row to predict the value of.}
\methoditem{col}{This is for internal use only.}
}}}}
\methodname{predictRow_(row)}{
This method \bold{must} be extended.  Using a model previously fit with \code{fitRow} to predict the  \code{row}th row of the next column. This function assumes that all of the data preprocessing has already been taken care of.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{row}{The row to predict the value of.}
}}
\item{Value}{private$output The return value should be both stored in  private$output and returned using return.  This should contain the  results of the prediction in a Forecast object with dimensions similar to private$newdata.}
}}
\methodname{predict_(col=0)}{
This method \bold{must} be extended.  Using a model previously fit with \code{fit} to predict each row of the  next column. This function assumes that all of the data preprocessing has already been taken care of.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{col}{Which columns of private$output should be modified.  This  parameter is mainly used in forecast, but could be used to store repeated predict_ calls in a single matrix.}
}}
\item{Value}{private$output The return value should be both stored in  private$output and returned using return.  This should contain the  results of the prediction in a Forecast object with dimensions similar to private$newdata.}
}}
\methodname{prepareFitData(data)}{
This method \bold{must} be extended.  Take \code{data} and store it in the object.  This allows the data to be referenced later in predict() where newdata is NULL.  It may also be helpful to put other data preparation steps in this method, so that the fit function runs more smoothly.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{ The data to prepare.}
}}}}
\methodname{prepareForecastData(data)}{
This method \bold{must} be extended.  This function takes input data and prepares it to forecast.  It should in  principle, be similar to preparePredictData, but sometimes forecasting  requires different preparation from prediction.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to prepare for forecasting from.}
}}
\item{Value}{private$newdata Store the processed value here, so that forecast can access it.}
}}
\methodname{prepareOutputData(inputData,steps=0)}{
This method \bold{must} be extended.  This function takes the input data and constructs an appropriate container for the output of the model.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{inputData}{The input to the model.  Used to determine properties of the container.}
\methoditem{steps}{If the input data is used as part of a forecast, the number of steps is passed in case the output size depends on the number of time steps.}
}}}}
\methodname{preparePredictData(newdata)}{
This method \bold{must} be extended.  Take \code{newdata} and use it to prepare the model, so that predicting doesn't need to directly reference it.  This allows the model to make multiple predict_, predictRow_, or forecast calls without re-allocating the data every time.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{ The data to prepare.}
}}}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
