% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{ytable_age_slice}
\alias{ytable_age_slice}
\title{Take an Age Slice out of an fe_yield_table_object}
\usage{
ytable_age_slice(age, variable, ytable)
}
\arguments{
\item{age}{The age (in years) for which the time slice has to be drawn}

\item{variable}{Name of the yield table variable for which the slice is to
be taken}

\item{ytable}{An object of class \code{\link{fe_yield_table}}}
}
\value{
A (named) vector representing the vertical slice of the desired
yield table variable. The names are the site indexes as defined in the
yield table's element \code{$site_index} (in the same order) with the
prefix "si_".
}
\description{
Age slices out of yield tables are typically required for finding out the
site index for a given age-height pair, or for extracting a yield table value
when age and site index are given.
}
\details{
If the age provided by the user is not directly contained in the table,
linear interpolation and also extrapolation is used for obtaining the age
slice. Currently, this is only done inside the general age span covered by
the table (slot \code{$age_coverage} of the yield table object). For ages
outside this range, the slice is given for the nearest covered age extreme,
and a warning is issued.
}
\examples{
  # Get the yield table heights of the Wiedemann 1943 Scots pine table at age
  # 73
  ytable_age_slice(
    fe_ytable_pine_wiedemann_moderate_1943,
    age = 73,
    variable = "h_q_m"
  )


}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
