% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_standard_gnfi3.R
\name{h_standard_gnfi3}
\alias{h_standard_gnfi3}
\title{Calculate Tree Heights with the Bavarian Standard Height Curve System of the
3rd German National Forest Inventory (2012)}
\usage{
h_standard_gnfi3(species_id, dbh_cm, d_q_cm, h_q_m)
}
\arguments{
\item{species_id}{Vector of species id's preferably following the
\emph{ger_nfi_2012} species coding. Ideally, these species_id's are provided as
a \code{\link{fe_species_ger_nfi_2012}} object. Second best, they are
provided in the \emph{tum_wwk_short} coding. For any other type of object, an
attempt will be made to convert into \emph{ger_nfi_2012} (and use the
corresponding parameters); if that fails, conversion to \emph{tum_wwk_short}
will be attempted (see details).}

\item{dbh_cm}{Vector of tree dbh values in cm (dbh = stem diameter at breast
height, i.e. 1.3 m)}

\item{d_q_cm}{Vector of quadratic mean stand diameters (will be recycled
following the rules for tibbles)}

\item{h_q_m}{Vector of quadratic mean stand heights (will be recycled
following the rules for tibbles)}
}
\value{
A vector of the estimated heights
}
\description{
Implementation of the standard height curve developed during the the 3nd
German National Forest Inventory
\insertCite{bwi3_methods_2017}{ForestElementsR}. Structurally, this is a
height curve system after Sloboda
\insertCite{sloboda_et_al_1993}{ForestElementsR} which allows to estimate a
tree's height when its species, diameter, and the quadratic mean diameter
and height of (the species in) the stand is given.
}
\details{
Originally, the height curve system was parameterized for species and species
groups corresponding to the national forest inventory's species coding
(\code{\link{fe_species_ger_nfi_2012}}).  We have attributed in addition these
the original parameters also to the species codings
\code{\link{fe_species_tum_wwk_short}}, and
\code{\link{fe_species_bavrn_state_short}}. When called with a given species
coding, the function will try to use the "nearest" of these three
alternatives. Fallback option is the attempt to use
\code{\link{fe_species_tum_wwk_short}}.

In order to provide maximum flexibility in applying the function
h_standard_gnfi3, the stand values (mean height, mean diameter) can be
provided with each tree diameter individually. This allows estimating heights
for trees from different stands at the same time. In the same way, the
provided species codes are not required to be the same for each tree.
}
\examples{
  # Three examples for single tree applications with species codes given
  # as integers (but following the ger_nfi_2012 coding)

  # European beech, dbh_cm < dq_cm
  h_standard_gnfi3(species_id = 100, dbh_cm = 14.8, d_q_cm = 25, h_q_m = 22)

  # Scots pine, dbh_cm == dq_cm
  h_standard_gnfi3(species_id = 20, dbh_cm = 25, d_q_cm = 25, h_q_m = 22)

  # Douglas fir, dbh_cm > dq_cm
  h_standard_gnfi3(species_id = 40, dbh_cm = 45, d_q_cm = 25, h_q_m = 22)

  # Same Douglas fir but species_id = 7 (i.e. tum_wwk_short),
  # note the message, because numeric 7 is not convertible into ger_nfi_2012
  h_standard_gnfi3(species_id = 7, dbh_cm = 45, d_q_cm = 25, h_q_m = 22)

  # But no message, when species_id = 7 is made a tum_wwk_short object first,
  # because this can be unambiguously converted into ger_nfi_2012
  h_standard_gnfi3(
    fe_species_tum_wwk_short(7), dbh_cm = 45, d_q_cm = 25, h_q_m = 22
  )

  # Usually, applications will be vectorized
  species_id <- fe_species_ger_nfi_2012(rep(20, 7))  # Seven Scots pines
  dbh <- c(10.1, 27.4, 31.4, 35.5, 39.8, 45.2, 47.2) # and their diameters
  # Estimate the heights of these trees, assuming they are from a
  # stand with a mean diameter of 35.5 cm, and a corresponding mean height
  # of 28 m.
  h_standard_gnfi3(species_id, dbh, d_q_cm = 35.5, h_q_m = 28.0)

  # Compare with sister function h_standard_bv, assuming a stand age of
  # 100 years
  h_standard_bv(species_id, dbh, age_yr = 100, d_q_cm = 35.5, h_q_m = 28.0)

}
\references{
\insertAllCited{}
}
\seealso{
Other standard height curve systems: 
\code{\link{h_standard_bv}()}
}
\concept{standard height curve systems}
