% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_helper_functions.R
\name{translate_spec_codes_into_names}
\alias{translate_spec_codes_into_names}
\title{Translate Species Codes into Names}
\usage{
translate_spec_codes_into_names(x, spec_lang = c("eng", "ger", "sci"), coding)
}
\arguments{
\item{x}{Object of one of the fe_species_id classes or a \code{character}
vector}

\item{spec_lang}{Choice of how species (group) names or id's are translated.
Supported choices are "eng" (English species names, default), "ger" (Geman
species names), and "sci" (scientific species names).}

\item{coding}{Name of the coding against which \code{x} is to be checked.
Must be one of the entries in the column \code{species_coding} in the data
file \code{\link{species_codings}}}
}
\value{
A \code{character} vector in the same order as \code{x}, containing
the species (group names) in the desired language
}
\description{
Translate Species Codes into Names
}
\keyword{internal}
