% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.asymmetric.tree.R
\name{rangeplot.asymmetric}
\alias{rangeplot.asymmetric}
\title{Make an asymmetric stratigraphic range plot from a tree object of class phylo}
\usage{
rangeplot.asymmetric(x, complete = FALSE, ...)
}
\arguments{
\item{x}{phylo object to plot.}

\item{complete}{Plot unsampled species.}

\item{...}{Additional parameters to be passed to \code{plot.default}.}
}
\description{
Make an asymmetric stratigraphic range plot from a tree object of class phylo
}
\note{
This function assumes all speciation events are asymmetric.
}
\examples{
tree = sim.fbd.taxa(n = 10, numbsim = 1, lambda = 3, mu = 2, psi = 1, complete = TRUE)[[1]]
rangeplot.asymmetric(tree, complete=TRUE)

}
