#' Print a Fourier descriptor object as generated by
#' \code{\link{random.fourier.descriptor}}
#' 
#' @include random-fourier.descriptor.R
#' @param fourier.descriptor A Fourier descriptor object generated by
#'   \code{\link{random.fourier.descriptor}}
#' @export
#' @examples
#' fourier.descriptor <- random.fourier.descriptor(12)
#'
#' print(fourier.descriptor)
#' @usage
#' fourier.descriptor <- random.fourier.descriptor(12)
#' 
#' print(fourier.descriptor)

print.fourier.descriptor <- function(x, ...)
{
  print('Class: fourier.descriptor')
  print(paste('Amplitude: <', paste(x[['Amplitude']], collapse = ', '), '>', sep = ''))
  print(paste('Phase: <', paste(x[['Phase']], collapse = ', '), '>', sep = ''))
}
