% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureEuclidean.R
\name{MeasureEuclidean}
\alias{MeasureEuclidean}
\title{Function to calculate the Euclidean distance between two fuzzy numbers.}
\usage{
MeasureEuclidean(value1, value2, trapezoidal = TRUE, ...)
}
\arguments{
\item{value1}{The first input triangular or trapezoidal fuzzy number.}

\item{value2}{The second input triangular or trapezoidal fuzzy number.}

\item{trapezoidal}{Logical value depending on the type of input fuzzy values (triangular or trapezoidal ones)}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a numerical value.
}
\description{
`MeasureEuclidean` calculates the Euclidean measure between two trapezoidal or triangular fuzzy numbers.
}
\details{
The procedure calculates the Euclidean measure of the distance between two trapezoidal or triangular fuzzy numbers.
The input values can be given as triangular/trapezoidal fuzzy numbers using the objects defined in \code{FuzzyNumbers} package
or vectors with three (in the case of triangular fuzzy numbers) or four (for trapezoidal fuzzy numbers) values related to
left end of the support, the core (or its interval, respectively), and the right end of the support.
The parameter \code{trapezoidal} is used to indicate if the input values are trapezoidal fuzzy numbers or triangular ones.
}
\examples{



# let's define two trapezoidal fuzzy numbers

tpfn1 <- c(1,2,3,4)

tpfn2 <- c(2,6,8,10)

# calculate the distance

MeasureEuclidean(tpfn1,tpfn2)

# now we use objects from the FuzzyNumbers package

# load the necessary library

library(FuzzyNumbers)

tpfn1 <- TrapezoidalFuzzyNumber(1,2,3,4)

tpfn2 <- TrapezoidalFuzzyNumber(2,6,8,10)

MeasureEuclidean(tpfn1,tpfn2)


}
\seealso{
\code{\link{MeasureAHD}, \link{MeasureHSD}} for other procedures to calculate distance measures.
}
