% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyTOPSISLinear.R
\name{FuzzyTOPSISLinear}
\alias{FuzzyTOPSISLinear}
\title{Implementation of Fuzzy TOPSIS Method for Multi-Criteria Decision Making Problems.}
\usage{
FuzzyTOPSISLinear(decision, weights, cb)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x (\emph{n}*3)) with the values of the \emph{m} alternatives, for the \emph{n} criteria, and multiplied by 3 since they are triangular fuzzy numbers.}

\item{weights}{A vector of length \emph{n}*3, containing the fuzzy weights for the criteria.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}
}
\value{
\code{FuzzyTOPSISLinear} returns a data frame which contains the score of the R index and the ranking of the alternatives.
}
\description{
The \code{FuzzyTOPSISLinear} function implements the Fuzzy Technique for Order of Preference by Similarity to Ideal Solution (Fuzzy TOPSIS) Method with de linear transformation (maximum) as normalization method.
}
\examples{

 d <- matrix(c(5.7,6.3,6.3,7.7,8.3,8,9.3,9.7,9,5,9,7,7,10,9,9,10,10,5.7,8.3,7,7.7,9.7,9,
 9,10,10,8.33,9,7,9.67,10,9,10,10,10,3,7,6.3,5,9,8.3,7,10,9.7),nrow=3,ncol=15)
 w <- c(0.7,0.9,1,0.9,1,1,0.77,0.93,1,0.9,1,1,0.43,0.63,0.83)
 cb <- c('max','max','max','max','max')
 FuzzyTOPSISLinear(d,w,cb)
}
\references{
Chen, C.T. Extensions of the TOPSIS for group decision-manking under fuzzy environment. Fuzzy Sets and Systems, 114, 1-9, 2000.
}

