% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-02-PowerFuzzyNumber.R
\docType{class}
\name{PowerFuzzyNumber-class}
\alias{PowerFuzzyNumber-class}
\title{S4 class Representing a Fuzzy Number with Sides Given by Power Functions}
\description{
Bodjanova-type fuzzy numbers which sides are given by power functions
are defined using four coefficients
\code{a1} <= \code{a2} <= \code{a3} <= \code{a4},
and parameters \code{p.left}, \code{p.right}>0, which determine
exponents for the side functions.
}
\details{
We have \eqn{\mathtt{left}(x)=x^{\mathtt{p.left}}}{left(x)=x^p.left},
and \eqn{\mathtt{right}(x)=(1-x)^{\mathtt{p.right}}}{right(x)=(1-x)^p.right}.

This class is a natural generalization of trapezoidal FNs.
For other see \linkS4class{PiecewiseLinearFuzzyNumber}.
}
\section{Slots}{

 \describe{
   \item{\code{a1}, \code{a2}, \code{a3}, \code{a4},
   \code{lower}, \code{upper}, \code{left}, \code{right}:}{
   Inherited from the \code{\linkS4class{FuzzyNumber}} class.}
   \item{\code{p.left}:}{single numeric value; 1.0 for a trapezoidal FN.}
   \item{\code{p.right}:}{single numeric value; 1.0 for a trapezoidal FN.}
 }
}

\section{Extends}{

Class \code{\linkS4class{FuzzyNumber}}, directly.
}

\examples{
showClass("PowerFuzzyNumber")
showMethods(classes="PowerFuzzyNumber")
}
\references{
Bodjanova S. (2005), Median value and median interval of a fuzzy number,
Information Sciences 172, pp. 73-89.
}
\seealso{
\code{\link{PowerFuzzyNumber}} for a convenient constructor,
\code{\link{as.PowerFuzzyNumber}} for conversion of objects to this class.

\code{\link{PowerFuzzyNumber}} for a convenient constructor

Other PowerFuzzyNumber-method: \code{\link{PowerFuzzyNumber}},
  \code{\link{alphaInterval}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}},
  \code{\link{expectedInterval}}
}
\concept{PowerFuzzyNumber-method}
