% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_equate.R
\name{fs_equate}
\alias{fs_equate}
\title{Fuzzy supplementary poverty estimation}
\usage{
fs_equate(steps4_5, weight, HCR, interval = c(1, 10), verbose = TRUE)
}
\arguments{
\item{steps4_5}{The results obtained from \code{fs_weight}.}

\item{weight}{A numeric vector of sampling weights. if NULL simple random sampling weights will be used}

\item{HCR}{The head count ratio.}

\item{interval}{The range to look for the value of alpha.}

\item{verbose}{Logical. whether to print the proceeding of the procedure.}
}
\value{
The alpha parameter that solves the non-linear equation $E(mu) = HCR$
}
\description{
Step 6. This function solves $E(mu)^(alpha-1) = HCR$ for alpha.
}
\examples{
data(eusilc)
step2 = fs_transform(eusilc[,4:23], weight = eusilc$DB090, ID = eusilc$ID)
dimensions = c(1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5)
steps4_5 = fs_weight(dimensions, step2 = step2, rho = NULL)
alpha <- fs_equate(steps4_5 = steps4_5, weight = eusilc$DB090, HCR = .16, interval = c(1,10))
}
