#Not exported functions 
#The following functions are not exported and used in background by the package
#Users should only refer to exported functions
#For more information please contact the package maintainer.
#Functions used to compute the membership function:

fm_belhadj2011 <- function (x, z_min, z_max, weight, breakdown = NULL, ID = NULL) {
  N <- length(x)
  if(is.null(ID)) ID <- seq_len(N)
  if(z_min < min(x) | z_min > max(x))stop("The value of z_min has to be between the minimum and the maximum of the predicate")
  if(z_max < min(x) | z_max > max(x))stop("The value of z_max has to be between the minimum and the maximum of the predicate")
  if(z_max<z_min)stop("The value of z_max has to be > z_min")
  if(!is.null(weight) & length(x)!= length(weight))stop("The length of predicate and weight need to be the same")
  
  N <- length(x)
  y <- rep(NA_real_, N)
  y[0 <= x & x < z_min] <- 1
  y[z_min <= x & x < z_max] <- (z_max - x[z_min <= x & x < z_max])/(z_max-z_min)
  y[x >= z_max] <- 0
  if (!is.null(breakdown)) {
    estimate <- sapply(split(data.frame(y, weight, breakdown), f = ~ breakdown),
                       function(X) weighted.mean(X[["y"]], w = X[["weight"]]))
  }
  else {
    estimate <- weighted.mean(x = y, w = weight)
  }
  fm_data <- data.frame(ID = ID, predicate = x, weight = weight, mu = y)
  fm_data <- fm_data[order(fm_data$mu),]
  return(list(results = fm_data,
              estimate = estimate,
              parameters = list(z_min = z_min, z_max = z_max),
              fm = "belhadj2011"))
}

fm_belhadj2015 <- function(x, z1, z2, b, breakdown, weight, ID){
  
  if(!is.null(weight) & length(x)!= length(weight))stop("The length of predicate and weight need to be the same")
  if(z2 < min(x) | z1 > max(x))stop("The value of z1 has to be between the minimum and the maximum of the predicate")
  if(z2 < min(x) | z2 > max(x))stop("The value of z2 has to be between the minimum and the maximum of the predicate")
  if(z2<z1)stop("The value of z2 has to be > z1")
  # uniroot(ddx_ub2, z2, b, interval = c(0, 100))
  N <- length(x)
  if(is.null(ID)) ID <- seq_len(N)
  z <- uniroot(z_fun, z1, z2, b, interval = c(z1, z2), extendInt = "yes")$root
  mu <- belhadj2015(x, z1, z2, z, b)
  if(!is.null(breakdown)) {
    # estimate <- tapply( (mu*weight)/sum(weight), INDEX = breakdown, mean)
    estimate <- sapply(split(data.frame(mu, weight, breakdown), f = ~ breakdown), function(X) weighted.mean(X[["mu"]], w = X[["weight"]]))
  } else {
    estimate <- weighted.mean(x = mu, w = weight)
  }
  fm_data <- data.frame(ID = ID, predicate = x, weight = weight, mu = mu)
  fm_data <- fm_data[order(fm_data$mu),]
  return(list(results = fm_data,
              estimate = estimate,
              parameters = list(z1 = z1, z2 = z2, z = z, b = b),
              fm = "belhadj2015"))
}

belhadj2015 <- function(x, z1, z2, z, b){
  if(z1 < min(x) | z1 > max(x)) stop("The value of z1 has to be between the minimum and the maximum of the predicate")
  if(z2 < min(x) | z2 > max(x)) stop("The value of z2 has to be between the minimum and the maximum of the predicate")
  if(z2<z1) stop("The value of z2 has to be > z1")
  if(b<1) stop("The value of b has to be >=1")
  
  y <- x
  y[x<z1] <- 1
  y[x>=z2] <- 0
  y[z1<=x & x<z] <- ub1(x[z1<=x & x<z], z1, b)
  y[z<=x & x<z2] <- ub2(x[z<=x & x<z2], z2, b)
  return(y)
}

fm_ZBM <- function(predicate, hh.size, weight, breakdown , ID){
  # Zendini, Belhadi, Matoussi
  if(!is.null(weight) & length(predicate)!= length(weight))stop("The length of predicate and weight need to be the same")
  
  k <- 3 # The number of change points locations to estimate
  N <- length(predicate)
  if (is.null(ID)) ID <- seq_len(N)
  if(is.null(hh.size)) hh.size <- rep(1, N)
  
  #--- Step 0 ---#
  P <- bootP(x = predicate) # bootstrap estimates of percentiles
  a = P[99]; b = 0.5*(P[99] + P[100]); c = P[100]
  MGM <- MemberhsipGradesMatrix(x = predicate, P = P)
  
  #--- Step 1 ---#
  cluster.idx <- lapply(1:N, function(i) ecp::e.divisive( X = matrix(MGM[i,], ncol = 1), k = k)$cluster)
  
  #--- Step 2-3 ---#
  step2_3 <- lapply(1:N, function(i) tapply( MGM[i,], cluster.idx[[i]], max))
  step2_3.mat <- matrix(NA_real_, nrow = N, ncol = k, byrow = T, dimnames = list(NULL, 1:k))
  for(i in 1:N) step2_3.mat[i, names(step2_3[[i]])] = step2_3[[i]]
  # if(sum(!complete.cases(step2_3.mat))!=0) warning(paste("for", sum(!complete.cases(step2_3.mat)), "cases NA were generated by e.divisive\n"))
  step2_3.mat[is.na(step2_3.mat)] = 0
  
  #--- Step 4 ---#
  
  if(!is.null(breakdown)) {
    
    states.split <- split(data.frame(step2_3.mat, hh.size, weight, breakdown), f= ~ breakdown)
    Q <- t(sapply(states.split, function(Z) apply(Z[,1:k], 2, function(z) weighted.mean(x = z*Z[["hh.size"]], w = Z[["weight"]]))))
    colnames(Q) = c(1:k)
    P <- apply(Q, 1, Fuzzy_conv)
  } else {
    Q <- apply(step2_3.mat, 2, function(y) weighted.mean(x = y*hh.size, w = weight))
    P <- Fuzzy_conv(Q)
  }
  fm_data <- data.frame(ID = ID, predicate = predicate, weight = weight)
  order.idx <- order(fm_data$predicate)
  fm_data$mu = FN(fm_data$predicate,
                  a=a,
                  b=b,
                  c=c)
  fm_data <- fm_data[order.idx,]
  return(list( results = fm_data,
               MGM = MGM,
               mu_k =step2_3.mat[order.idx,],
               estimate = Q, parameters = list(P = P, k = k, a  = a, b = b, c = c), fm = "ZBM"))
}

fm_verma2 <- function (predicate, weight, ID, HCR, interval, alpha, breakdown, verbose) {
  if(!is.null(weight) & length(predicate)!= length(weight))stop("The length of predicate and weight need to be the same")
  if(!is.null(alpha)) if(alpha < 1) stop("The value of alpha has to be >=1")
  N <- length(predicate)
  if (is.null(ID)) ID <- seq_len(N)
  fm_data <- data.frame(ID = ID, predicate = predicate, weight = weight)
  if(!is.null(breakdown)) fm_data <- data.frame(fm_data, breakdown)
  fm_data <- fm_data %>% dplyr::arrange(predicate)
  
  predicate.ord <- fm_data[["predicate"]]
  weight.ord <- fm_data[["weight"]]
  if (is.null(alpha)) {
    if(verbose) cat("Solving non linear equation: E[u] = HCR\n")
    alpha <- uniroot(fm_objective,
                     interval = interval,
                     predicate.ord = predicate.ord,
                     weight.ord = weight.ord,
                     HCR = HCR,
                     fm = "verma2",
                     verbose)$root
    if(verbose) cat("Done.\n")
  }
  fm_data$mu <- fm_mu2(predicate.ord, weight.ord, alpha)
  estimate <- weighted.mean(fm_data$mu, fm_data$weight)
  if (!is.null(breakdown)) {
    fm_data <- split(data.frame(fm_data), f = ~ fm_data$breakdown)
    estimate <- sapply(fm_data, function(x) weighted.mean(x$mu, x$weight))
  }
  out <- list(results = fm_data, estimate = estimate, parameters = list(alpha = alpha), fm = "verma1999")
  return(out)
}

fm_TFR = function (predicate, weight, ID, HCR, interval, alpha, breakdown, verbose) {
  if(!is.null(alpha)) if(alpha < 1) stop("The value of alpha has to be >=1")
  if(!is.null(weight) & length(predicate)!= length(weight))stop("The length of predicate and weight need to be the same")
  N <- length(predicate)
  if (is.null(ID)) ID <- seq_len(N)
  fm_data <- data.frame(ID = ID, predicate = predicate, weight = weight)
  if(!is.null(breakdown)) fm_data <- data.frame(fm_data, breakdown = breakdown)
  
  fm_data <- fm_data %>% dplyr::arrange(predicate)
  
  predicate.ord <- fm_data[["predicate"]]
  weight.ord <- fm_data[["weight"]]
  if(is.null(alpha)) {
    if(verbose) cat("Solving non linear equation: E[u] = HCR\n")
    alpha <- uniroot(fm_objective,
                     interval = interval,
                     predicate.ord = predicate.ord,
                     weight.ord = weight.ord,
                     HCR = HCR,
                     fm = "TFR",
                     verbose)$root
    if(verbose) cat("Done.\n")
  }
  fm_data$mu <- fm_mu_TFR(predicate.ord, weight.ord, alpha)
  estimate <- weighted.mean(fm_data$mu, fm_data$weight)
  if (!is.null(breakdown)) {
    fm_data <- split(data.frame(fm_data), f = ~ fm_data$breakdown)
    estimate <- sapply(fm_data, function(x) weighted.mean(x$mu, x$weight))
  }
  out <- list(results = fm_data, estimate = estimate, parameters = list(alpha = alpha), fm = "TFR")
  return(out)
}

fm_cerioli<- function (x, z1, z2, weight, breakdown, ID) {
  if(z1 < min(x) | z1 > max(x))stop("The value of z1 has to be between the minimum and the maximum of the predicate")
  if(z2 < min(x) | z2 > max(x))stop("The value of z2 has to be between the minimum and the maximum of the predicate")
  if(z2<z1)stop("The value of z2 has to be > z1")
  if(!is.null(weight) & length(x)!= length(weight))stop("The length of predicate and weight need to be the same")
  
  N <- length(x)
  if(is.null(ID)) ID <- seq_len(N)
  
  y <- rep(NA_real_, N)
  y[0 <= x & x < z1] <- 1
  y[z1 <= x & x < z2] <- (z2 - x[z1 <= x & x < z2])/(z2-z1)
  y[x >= z2] <- 0
  if (!is.null(breakdown)) {
    estimate <- sapply(split(data.frame(y, weight, breakdown), f = ~ breakdown),
                       function(X) weighted.mean(X[["y"]], w = X[["weight"]]))
  }
  else {
    estimate <- weighted.mean(x = y, w = weight)
  }
  fm_data <- data.frame(ID = ID, predicate = x, weight = weight, mu = y)
  fm_data <- fm_data[order(fm_data$mu),]
  return(list(results = fm_data,
              estimate = estimate,
              parameters = list(z1 = z1, z2 = z2),
              fm = "cerioli"))
}

fm_Chakravarty <- function(x, z, weight, breakdown, ID){
  if(z < min(x) | z > max(x)) stop("The value of z has to be between the minimum and the maximum of the predicate")
  if(!is.null(weight) & length(x)!= length(weight))stop("The length of predicate and weight need to be the same")
  
  N <- length(x)
  if(is.null(ID)) ID <- seq_len(N)
  y <- rep(NA_real_, N)
  y[x == 0] <- 1
  y[0<=x & x < z] <- (z - x[0<=x & x < z])/z
  y[x>=z] <- 0
  
  if(!is.null(breakdown)){
    estimate <- sapply(split(data.frame(y, weight, breakdown), f = ~ breakdown), function(X) weighted.mean(X[["y"]], w = X[["weight"]]))
  } else {
    estimate <- weighted.mean(x = y, w = weight)
  }
  fm_data <- data.frame(ID = ID, predicate = x, weight = weight, mu = y)
  fm_data <- fm_data[order(fm_data$mu),]
  return(list(results = fm_data,
              estimate = estimate,
              parameters = list(z = z),
              fm = "chakravarty"))
}

fm_verma <- function(predicate, weight, ID, HCR, interval, alpha, breakdown, verbose){ # cambiare ordine dei parametri
  if(!is.null(alpha)) if(alpha < 1) stop("The value of alpha has to be >=1")
  if(!is.null(weight) & length(predicate)!= length(weight))stop("The length of predicate and weight need to be the same")

  N <- length(predicate)
  if(is.null(ID)) ID <- seq_len(N)
  if(!is.null(breakdown)) {
    fm_data <-  data.frame(ID = ID, predicate = predicate, weight = weight, breakdown = breakdown) %>% arrange(predicate)
  } else {
    fm_data <-  data.frame(ID = ID, predicate = predicate, weight = weight) %>% arrange(predicate)
  }
  
  predicate.ord <- fm_data[['predicate']]
  weight.ord <- fm_data[['weight']] # actually ordered according to predicate
  
  if(is.null(alpha)){
    if(verbose) cat('Solving non linear equation: E[u] = HCR\n')
    alpha <- uniroot(fm_objective,
                     interval = interval,
                     predicate.ord = predicate.ord,
                     weight.ord = weight.ord,
                     HCR = HCR,
                     fm = "verma",
                     verbose)$root
    if(verbose) cat('Done.\n')
  }
  
  fm_data$mu <- fm_mu(predicate.ord, weight.ord, alpha)
  estimate <- weighted.mean(fm_data$mu, fm_data$weight)
  
  if(!is.null(breakdown)){
    
    fm_data.list <- split(fm_data, f = ~ breakdown)
    estimate <- sapply(fm_data.list, function(x) weighted.mean(x$mu, x$weight))
    
    # fa funzioni di appartenenza per ogni breakdown. per altro paper ;T
    
    # fm_data.list <- split(fm_data, breakdown) %>% lapply(function (x) x %>% arrange(predicate))
    # mu.list <- lapply(fm_data.list, function(x) fm_mu(x$predicate, x$weight, alpha))
    # fm_data.list <- Map(cbind, fm_data.list, mu.list); for(i in 1:length(fm_data.list)) colnames(fm_data.list[[i]]) <- c('ID', 'predicate','weight','membership')
    # fm_estimates <- sapply(fm_data.list, function(x) weighted.mean(x$membership, x$weight))
    # return(list(results = fm_data.list, estimates = fm_estimates, alpha = alpha))
    
  }
  out <- list(results = fm_data, estimate = estimate, parameters = list(alpha = alpha), fm = "verma")
  return(out)
  
}

#Other secondary functions used to not have dependencies or to compute the 
#Parameters linked with the membership functions

ub1 <- function(x, z1, b){
  return( 1-0.5*((x-z1)/z1)^b)
}

ub2 <- function(x, z2, b){
  return( 0.5*((z2-x)/z2)^b )
}

z_fun <- function(x, z1, z2, b){
  return( ub1(x, z1, b) - ub2(x, z2, b))
}

bootP <- function(x, R = 500){
  M <- length(x)
  bootReps <- replicate(R, sample(x, size = M, replace = TRUE))
  boot.p <- apply(bootReps, 2, quantile, probs = seq(0.01, 1, 0.01))
  P <- apply(boot.p, 1, mean)
  return(P)
}

FN <- function(x, a, b, c){
  y <- rep(NA_real_, length(x))
  y[x<a | x >= c] <- 0
  y[a<=x & x<= b] <- 1
  y[b<=x & x < c] = x[b<=x & x<c]*(-1/(c-b))+(c/(c-b))
  return(y)
}

MemberhsipGradesMatrix <- function(x, P){
  n <- length(x)
  MGM <- matrix(0, nrow = n, ncol = 1)
  MGM[,1] <- FN(x = x, a = 0, b = P[1], c = P[2])
  MGM <- cbind(MGM, do.call(cbind, lapply(2:99, function(j) FN(x = x, a = P[j-1], b = P[j], c = P[j+1]))))
  MGM <- cbind(MGM, FN(x = x, a = P[99], b = 0.5*(P[99] + P[100]), c = P[100]))
  return(MGM)
}

Fuzzy_conv <- function(x) {
  Min <- Vectorize(function(a,b) min(a,b), vectorize.args = "b")
  Max <- Vectorize(function(a,b) max(a,b), vectorize.args = "b")
  l <- length(x)
  m <- Min(x[1], x[2:l])
  P <- Max(m[1], m[2:length(m)])
  return(P)
}

fm_mu2 <- function (predicate.ord, weight.ord, alpha) {
  N = length(predicate.ord)
  tot2 = sum((predicate.ord * weight.ord)[2:N])
  L <- rep(0, N)
  cond <- predicate.ord > predicate.ord[1]
  tot2 <- sum((predicate.ord * weight.ord) * cond)
  i <- 1
  while (i < N) {
    flag_i <- predicate.ord > predicate.ord[i]
    L[i] <- sum((predicate.ord * weight.ord)[flag_i])/tot2
    i <- i + 1
  }
  u <- L^(alpha)
  return(u)
}

fm_mu_TFR = function (predicate.ord, weight.ord, alpha) {
  N = length(predicate.ord)
  tot1 = sum(predicate.ord[2:N])
  F <- rep(0, N)
  cond <- predicate.ord > predicate.ord[1]
  tot1 <- sum(weight.ord * cond)
  i <- 1
  while (i < N) {
    flag_i <- predicate.ord > predicate.ord[i]
    F[i] <- sum(weight.ord * flag_i)/tot1
    i <- i + 1
  }
  u <- as.numeric(F^(alpha) )
  return(u)
}

fm_FL <- function(predicate.ord, weight.ord){
  
  N = length(predicate.ord)
  tot1 = sum(predicate.ord[2:N])
  tot2 = sum( (predicate.ord*weight.ord)[2:N] )
  
  F1 <- rep(0,N)
  L1 <- rep(0,N)
  
  cond <- predicate.ord > predicate.ord[1]
  tot1 <- sum( weight.ord*cond )
  tot2 <- sum( (predicate.ord*weight.ord)*cond )
  
  i <-  1
  while(i < N) {
    flag_i <- predicate.ord > predicate.ord[i]
    F1[i] <- sum( weight.ord*flag_i ) / tot1
    L1[i] <- sum( (predicate.ord*weight.ord)[ flag_i ]) / tot2
    i <- i + 1
  }
  
  return(list(WECDF = F1, Lorenz = L1))
}

fm_mu <- function(predicate.ord, weight.ord, alpha){
  
  N = length(predicate.ord)
  tot1 = sum(predicate.ord[2:N])
  tot2 = sum( (predicate.ord*weight.ord)[2:N] )
  
  F <- rep(0,N)
  L <- rep(0,N)
  
  cond <- predicate.ord > predicate.ord[1]
  tot1 <- sum( weight.ord*cond )
  tot2 <- sum( (predicate.ord*weight.ord)*cond )
  
  i <-  1
  while(i < N) {
    flag_i <- predicate.ord > predicate.ord[i]
    F[i] <- sum( weight.ord*flag_i ) / tot1
    L[i] <- sum( (predicate.ord*weight.ord)[ flag_i ]) / tot2
    i <- i + 1
  }
  
  u <- F^(alpha-1)*L
  
  return(u)
}

fuzzyScaleItem = function(item, weight, ID, ...){
  if( !is.null(weight) & length(item)!= length(weight))stop("The length of predicate and weight need to be the same")
  
  ordered_item = factor(item, ordered = T)
  
  weight_sum = sum(weight)
  
  # compute weights
  outW <- data.frame(ID = 1:length(ordered_item), # ID riga
                     ordered_item,
                     weight = weight) %>%
    dplyr::arrange(ordered_item) %>%
    dplyr::group_by(ordered_item) %>%
    dplyr::mutate(f = sum(weight)/weight_sum) # per ogni livello di item sommo i pesi e divido per la somma dei pesi
  
  tmp <- unique(data.frame(ordered_item = outW$ordered_item,
                           f = outW$f))
  
  tmp <- data.frame(tmp, F_cum = cumsum(tmp$f))
  
  # join weights with individual information
  outW2 = outW %>%
    dplyr::inner_join(tmp %>% select(ordered_item, F_cum), by = c("ordered_item" = "ordered_item")) %>%
    dplyr::ungroup() %>%
    dplyr::mutate(s = round((1 - F_cum) / (1 - min(F_cum)),5), # changed to ensure comparability with betti due to R factor coding
                  d = 1 - s,
                  Item = item) %>%
    # filter(item != Weight) %>% # PERCHé QUESTO PASSAGGIO?
    dplyr::arrange(ID) %>% dplyr::select(ID,
                                         Item,
                                         Item_level = ordered_item,
                                         F_cum, # POSSO ANCHE OMETTERE
                                         d,s )
  
  return(outW2)
  
}

fm_equate <- function(predicate.ord, weight.ord, interval, verbose){
  
  alpha <- uniroot(fm_objective,
                   interval = interval,
                   predicate.ord = predicate.ord,
                   weight.ord = weight.ord,
                   HCR = HCR,
                   verbose)$root
  if(verbose) cat('Done.\n')
  return(alpha)
}

fm_objective <- function(predicate.ord, weight.ord, alpha, HCR, fm, verbose){
  switch(fm,
         verma = {FM <- fm_mu(predicate.ord, weight.ord, alpha)},
         verma2 = {FM <- fm_mu2(predicate.ord, weight.ord, alpha)},
         TFR = {FM <- fm_mu_TFR(predicate.ord, weight.ord, alpha)})
  if(verbose) cat('trying with alpha: ', round(alpha, 3) , ' Expected Value: ', round(weighted.mean(x = FM, w = weight.ord), 3), "\n")
  return( weighted.mean(x = FM, w = weight.ord) - HCR )
}

fs_objective <- function(s.ord, w.ord, alpha, HCR, verbose){
  FS <- fs_mu(s.ord, w.ord, alpha)
  if(verbose) cat('trying with alpha: ', round(alpha, 4) , ' Expected Value: ', round(weighted.mean(x = FS, w = w.ord), 4), "\n")
  return( weighted.mean(x = FS, w = w.ord) - HCR )
}

weighted_quantile <- function(x, w, p) {
  
  na.idx <- is.na(x)
  x <- x[!na.idx]
  w <- w[!na.idx]
  
  n <- length(x)
  sum.w <- sum(w)
  cond <- p*sum.w
  order.idx <- order(x)
  x.ord <- x[order.idx]
  w.ord <- w[order.idx]
  
  w.cd <- cumsum(w.ord)
  test <- (w.cd == cond)
  if(any(test)){
    low.idx <- which(test)
    up.idx <- low.idx+1
    q_p <- 0.5*(x.ord[low.idx]+x.ord[up.idx])
    
  } else {
    low.idx <- sum(w.cd < cond)
    up.idx <- low.idx+1
    q_p <- x.ord[up.idx]
    
  }
  return(q_p)
}

modifiedSum <- function(x, y) {
  
  replace(x, is.na(x), 0) + replace(y, is.na(y), 0)
}

fs_mu <- function(s.ord, w.ord, alpha){
  
  #@ s.ord. a sorted vector of deprivation scores.
  #@ w.ord a sorted vector of weights (in the same order of s.ord)
  N = length(s.ord)
  tot1 = sum(s.ord[2:N])
  tot2 = sum( (s.ord*w.ord)[2:N] )
  
  F <- rep(0,N)
  L <- rep(0,N)
  
  cond <- s.ord > s.ord[1]
  tot1 <- sum( w.ord*cond )
  tot2 <- sum( (s.ord*w.ord)*cond )
  
  i <-  1
  while(i < N) {
    flag_i <- s.ord > s.ord[i]
    F[i] <- sum( w.ord*flag_i ) / tot1
    L[i] <- sum( (s.ord*w.ord)[ flag_i ]) / tot2
    i <- i + 1
  }
  
  mu <- F^(alpha-1)*L
  return(mu)
}

wb.jh <- function(j, step2, dimensions, rho, ...){
  col_sel <- (dimensions==j)
  X <- step2[,col_sel]
  cor.mat.h = cor( X , method = "kendall" ); cor.mat.h[is.na(cor.mat.h)] <- 0L # to avoid strange rhos in bootstrap (-inf) and rhos greater than 1
  if(is.null(rho)) rho <- max( diff( sort( c(1, cor.mat.h[upper.tri(cor.mat.h)] ), decreasing = F) ) ) # critical value
  # print(cor.mat.h); print(rho)
  wb_jh.denom.first <- apply(cor.mat.h, 2, function(x) 1/(1 + sum( x[x < rho], na.rm = T )) ) # remove na for NA in cor matrix
  wb_jh.denom.sec <- apply(cor.mat.h, 2, function(x) 1/sum(x[x > rho], na.rm = T ) ) # remove na for NA in cor matrix
  wb_jh <- (wb_jh.denom.first*wb_jh.denom.sec) # returns the weights for items j_1, j_2,..., j_h in the h dimension.
  
  return(wb_jh)
}

#S3 classes 

FuzzyPoverty <- function(x){
  class(x) <- "FuzzyMonetary"
  return(x)
}

FuzzySupplementary <- function(x){
  class(x) <- "FuzzySupplementary"
  return(x)
}



