% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_summary.R
\name{summary.FuzzySupplementary}
\alias{summary.FuzzySupplementary}
\title{The summary of a FuzzySupplementary object}
\usage{
\method{summary}{FuzzySupplementary}(object, ...)
}
\arguments{
\item{object}{An object of class "FuzzySupplementary"}

\item{...}{Additional options}
}
\value{
The summary method for class "FuzzySupplementary"
}
\description{
Summary method for class "FuzzySupplementary"
}
\examples{

#This example is based on the dataset eusilc included in the package
#The summary of FS index is compute with breakdown and using an HCR = 0.12

FS <- fs_construct_all(data = eusilc[,4:23], weight = eusilc$DB090, # step 2
                       dimensions = c(1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5), # step 3
                       rho = NULL, # steps 4 and 5
                       HCR = .12, # step 6
                       breakdown = eusilc$db040) # step 7 with breakdowns
summary(FS)

}
