% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf_counts_SNP_genecoords.R
\name{vcf_counts_SNP_genecoords}
\alias{vcf_counts_SNP_genecoords}
\title{VCF gene position counts}
\usage{
vcf_counts_SNP_genecoords(
  vcf_data,
  df_snppos,
  df_genecoords,
  keep_indiv = NULL,
  extract_SNP = NULL,
  filter_gene = NULL
)
}
\arguments{
\item{vcf_data}{an object of vcfR class}

\item{df_snppos}{a dataframe for SNP information with SNP BP as column names.}

\item{df_genecoords}{a dataframe for gene boundaries with CHR START END GENE as column names. Where CHR should be integer 1-22. START and END column should be integer. GENE column contains gene names}

\item{keep_indiv}{an option to specify individuals to retain. Mutation counts will be provided for individuals included in the list only. Default is all individuals. Provide list of individuals in a vector.}

\item{extract_SNP}{an option to specify SNPs for which mutation counts are needed. Mutation counts will be provided for SNPs included in the list only. Default is all SNPs.}

\item{filter_gene}{an option to filter in Genes. Mutation counts will be provided for genes included in the list only. Default is all genes.}
}
\value{
Returns an matrix of data.table class as an output with allelic (reference) gene counts within each sample where each row corresponds to gene and column to individual IDs from column second. The first column contains gene names.
}
\description{
Function returns a matrix with allelic counts per gene per individual for SNP and gene coordinates as inputs
}
\examples{
\dontrun{
vcf_counts_SNP_genecoords(vcf_data_test,df_snppos_test,df_genecoords_test)
}

}
\author{
Sanjeev Sariya
}
