% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.plot.R
\name{fit.plot}
\alias{fit.plot}
\title{Plot of the estimated Lorenz curve and the empirical income shares}
\usage{
fit.plot(fit, fit.type = 1, fit.legend = FALSE, l.size = 0.7)
}
\arguments{
\item{fit}{A character string "name" naming the object that contains the estimation of the parametric model for which the Lorenz curve is plotted.}

\item{fit.type}{specifies the method used to estimate the parametric model. By default, \code{fit.type = 1}, which represents the Lorenz curve estimated by NLS. If \code{fit.type = 2}, the Lorenz curve belongs to the GMM estimation.}

\item{fit.legend}{If \code{TRUE}, the graph includes a legend indicating the model for which the Lorenz curve is plotted.}

\item{l.size}{determines the size of the legend.}
}
\value{
the function \code{fit.plot} returns a graph with the theoretical Lorenz curves of the Generalised Beta of the Second Kind (GB2) family of income distributions and the income shares used for the estimation of these models.
}
\description{
The function \code{fit.plot} plots the parametric Lorenz curve and the observed income shares used for the estimation of the income distributions belonging to the GB2 family.
}
\details{
The function \code{fit.plot} represents the parametric Lorenz curves of some models of the GB2 family. Closed expressions
 of the Lorenz curves of these models are provided by Jorda et al. (2018). The parametric model must be estimated
before representing the theoretical Lorenz curve. To do so, create an object containing the result of the following functions:
 \code{\link{fitgroup.gb2}}, \code{\link{fitgroup.b2}}, \code{\link{fitgroup.da}},
\code{\link{fitgroup.sm}}, \code{\link{fitgroup.ln}} or \code{\link{fitgroup.f}}. The name of this object is used (with quotations marks)
as the first argument of \code{fit.plot} (see examples below). This function returns a plot with the Lorenz curve of the model
estimated by NLS or GMM. More than one fit can be plotted, even when different sets of data are used. The legend indicates the
distribution for which the Lorenz curve is represented.
}
\examples{
fit.ln <- fitgroup.ln(y = c(9, 13, 17, 22, 39), gini.e = 0.29)
fit.b2 <- fitgroup.b2(y = c(9, 13, 17, 22, 39), gini.e = 0.29)
fit.plot(c("fit.ln", "fit.b2"), fit.legend = TRUE, l.size = 0.8)
}
\references{
Jorda, V., Sarabia, J.M., & Jäntti, M. (2018). Estimation of income inequality from grouped data.
 arXiv preprint arXiv:1808.09831.
}

