% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{get_bw}
\alias{get_bw}
\title{Get an optimal bandwidth using Bartlett kernel}
\usage{
get_bw(y)
}
\arguments{
\item{y}{A \eqn{T\times 1} vector of time series}
}
\value{
A numeric.
}
\description{
Automatic bandwidth selection of Andrews (1991) using Bartlett kernel.
}
\examples{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
lT_G <- get_bw(est_multi$G)
}
\references{
Andrews, D.W., 1991. Heteroskedasticity and autocorrelation
consistent covariance matrix estimation. Econometrica: Journal of the
Econometric Society, pp.817-858.
}
