% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input.R
\name{check_input}
\alias{check_input}
\title{Check input prior to processing in GCalignR}
\usage{
check_input(data, plot = FALSE, sep = "\\t", ...)
}
\arguments{
\item{data}{Path to a data file or the name of a list in the global environment.}

\item{plot}{Logical, if TRUE the distribution of peak numbers is plotted. By default no plot is returned.}

\item{sep}{The field separator character. The default is tab separated (\code{sep = '\\t'}).
See the "sep" argument in \code{\link[utils]{read.table}} for details.}

\item{...}{optional arguments passed to methods, see \code{\link[graphics]{barplot}}. Reguires \code{plot == TRUE}.}
}
\value{
If \code{plot = TRUE} a data frame containing sample names and the corresponding number of peaks is returned
}
\description{
Checks formatting of GCalignR input data for some of the main errors. Data is accepted in
form of the path to a text file (i.e. "data.txt") or a list of data frames.
See \code{\link{align_chromatograms}} for details.
}
\details{
Sample names should contain just letters, numbers and underscores and no whitespaces.
Each sample has to contain the same number of columns, one of which is the retention
time and the others are the other variables. All values should be numeric, i.e. they
are allowed to contain numbers from 0-9 and "." as the only decimal character. Have a look
at the vignettes for examples.
}
\examples{
## gc-data
data("peak_data")
## Checks format
check_input(peak_data)
## Includes a barplot of peak numbers in the raw data
check_input(peak_data, plot = TRUE)

}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com) & Meinolf Ottensmann
 (meinolf.ottensmann@web.de)
}

