% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disc.R
\name{disc}
\alias{disc}
\alias{print.disc}
\alias{plot.disc}
\title{Generates discretization parameters for continuous data.}
\usage{
disc(var, n, method = "quantile", ManualItv)
\method{print}{disc}(x, ...)
\method{plot}{disc}(x, ...)
}
\arguments{
\item{var}{A numeric vector of continuous variable}

\item{n}{The numeber of intervals}

\item{method}{A character of discretization method}

\item{ManualItv}{A numeric vector of manual intervals}

\item{x}{A list of \code{disc} result}

\item{...}{Ignore}
}
\description{
Function for discretizing continuous data and obtaining the
different outputs, including discretization intervals, numbers of values
within intervals, and visualization of discretization.
}
\examples{
## method is default (quantile); number of intervals is 4
ds1 <- disc(ndvi_40$Tempchange, 4)
ds1
## method is equal; number of intervals is 4
ds2 <- disc(ndvi_40$Tempchange, 4, method = "equal")
## method is manual; number of intervals is 4
manualitv1 <- c(-0.5, 0, 1, 2, 4)
ds3 <- disc(ndvi_40$Tempchange, 4, method = "manual", ManualItv = manualitv1)
}
