% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Spatialmod_LogLikelihood.R
\name{Sim_Loglik}
\alias{Sim_Loglik}
\title{This function calculates the value of the log-likelihood function}
\usage{
Sim_Loglik(
  Nlabel,
  phi,
  Di,
  alpha1,
  delta,
  lambda,
  sigma1,
  beta1,
  beta2,
  time,
  n,
  zz,
  tau,
  lambda1,
  I,
  D,
  cov1,
  cov2
)
}
\arguments{
\item{Nlabel}{Label for each sample from the area}

\item{phi}{Spatial random effects}

\item{Di}{Euclidean distance between susceptible individual and infectious individual}

\item{alpha1}{intercept}

\item{delta}{Spatial parameter}

\item{lambda}{a vector containing the length of infectious period}

\item{sigma1}{precision of spatial random effects}

\item{beta1}{the parameter corresponding to the covariate associated with susceptible individual}

\item{beta2}{the parameter corresponding to the covariate associated with area}

\item{time}{time}

\item{n}{Total number of individuals}

\item{zz}{Number of areas}

\item{tau}{the set of infectious individuals at time t in the zth area}

\item{lambda1}{Spatial dependence}

\item{I}{Identity matrix}

\item{D}{matrix reflecting neighborhood structure}

\item{cov1}{Individual level covariates}

\item{cov2}{Area level covariates}
}
\value{
a numeric value for the log-likelihood
}
\description{
This function calculates the value of the log-likelihood function
}
\examples{
Sim_Loglik(rep(1:4,each=5), runif(4,min = 0, max = 1),
matrix(runif(400,min=4,max=20),nrow=20,byrow=TRUE),0.4, 2,rep(3,20),0.5,1,1,
10,20,4,sample(c(0,1),replace = TRUE, size = 20),0.6,diag(4),
matrix(c(0,-1,0,-1,-1,0,-1,-1,0,-1,0,-1,-1,-1,-1,0),nrow=4,byrow=TRUE),
runif(20, 0, 1), runif(4, 0, 1))

}
