% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand_coefficient.R
\name{demand_coefficient}
\alias{demand_coefficient}
\title{Compute Demand Coefficients of a Sector with a Demand Sturctural Tree}
\usage{
demand_coefficient(node, p)
}
\arguments{
\item{node}{the demand structural tree.}

\item{p}{the price vector with names of commodities.}
}
\value{
A vector consisting of demand coefficients.
}
\description{
Given a price vector, this function computes the demand coefficients of a sector with a demand structural tree. The class of a demand structural tree is Node defined by the package data.tree.
For a CES function, this function always assume that it has a standard form such as
alpha * (beta1 * (x1 / beta1)^sigma + beta2 * (x2 / beta2)^sigma)^(1 / sigma).
}
\examples{
dst <- Node$new("firm", type = "Leontief", a = c(0.5, 0.1))
dst$AddChild("wheat")$AddSibling("iron")
plot(dst)

demand_coefficient(dst, p = c(wheat = 1, iron = 2)) # the same as a = c(0.5, 0.1)

####
dst <- Node$new("firm", type = "CD", alpha = 1, beta = c(0.5, 0.5))
dst$AddChild("wheat")$AddSibling("iron")

demand_coefficient(dst, p = c(wheat = 1, iron = 2))
# the same as the following
CD_A(1, c(0.5, 0.5), c(1, 2))

####

dst <- Node$new("firm",
  type = "CES", sigma = -1,
  alpha = 2, beta = c(0.8, 0.2), theta = c(0.8, 0.2)
)
dst$AddChild("wheat")$AddSibling("iron")

demand_coefficient(dst, p = c(wheat = 1, iron = 2))
# the same as the following
CES_A(sigma = -1, alpha = 2, Beta = c(0.8, 0.2), p = c(1, 2), Theta = c(0.8, 0.2))

####
dst <- Node$new("firm",
  func = function(p) CES_A(sigma = -1, alpha = 2, Beta = c(0.8, 0.2), p, Theta = c(0.8, 0.2))
)
dst$AddChild("wheat")$AddSibling("iron")
demand_coefficient(dst, p = c(wheat = 1, iron = 2))
# the same as the following
CES_A(sigma = -1, alpha = 2, Beta = c(0.8, 0.2), p = c(1, 2), Theta = c(0.8, 0.2))

####
p <- c(wheat = 1, iron = 3, labor = 2, capital = 4)

dst <- Node$new("firm 1", type = "CES", sigma = -1, alpha = 1, beta = c(1, 1))
dst$AddChild("cc1", type = "Leontief", a = c(0.6, 0.4))$
  AddChild("wheat")$AddSibling("iron")
dst$AddChild("cc2", type = "CES", sigma = -1, alpha = 1, beta = c(1, 1))$
  AddChild("labor")$AddSibling("capital")
plot(dst)
demand_coefficient(dst, p)

####
p <- c(product = 1, labor = 1, money = 1)
dst <- Node$new("firm", type = "FIN", rate = c(1, 1 / 3)) # Financial-type Demand Structure
dst$AddChild("cc1", type = "Leontief", a = c(0.6, 0.15))$
  AddChild("product")$AddSibling("labor")$
  parent$
  AddSibling("money")
plot(dst)
demand_coefficient(dst, p)
}
