% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemTax_5_4.R
\name{gemTax_5_4}
\alias{gemTax_5_4}
\title{A General Equilibrium Model with Tax (see Cardenete et al., 2012).}
\usage{
gemTax_5_4(
  dstl,
  names.commodity = c("prod1", "prod2", "lab", "cap", "tax"),
  names.agent = c("taxed.firm1", "taxed.firm2", "consumer1", "consumer2"),
  delta = 1,
  supply.lab.consumer1 = 30,
  supply.cap.consumer1 = 20,
  supply.lab.consumer2 = 20,
  supply.cap.consumer2 = 5
)
}
\arguments{
\item{dstl}{the demand structure tree list.}

\item{names.commodity}{names of commodities.}

\item{names.agent}{names of agents.}

\item{delta}{the proportion of tax revenue allocated to consumer 1.
1-delta is the proportion of tax revenue allocated to consumer 2.}

\item{supply.lab.consumer1}{the labor supply of consumer 1.}

\item{supply.cap.consumer1}{the capital supply of consumer 1.}

\item{supply.lab.consumer2}{the labor supply of consumer 2.}

\item{supply.cap.consumer2}{the capital supply of consumer 2.}
}
\value{
A general equilibrium, which is a list with the following elements:
\itemize{
\item p - the price vector with labor as numeraire.
\item D - the demand matrix.
\item DV - the demand value matrix.
\item SV - the supply value matrix.
\item ... - some elements returned by the CGE::sdm function
}
}
\description{
This is a general equilibrium model with tax (see chapter 4, Cardenete et al., 2012).
}
\details{
A general equilibrium model with 5 commodities (i.e. product 1, product 2, labor, capital goods,
and tax) and 4 agents (i.e. 2 firms and 2 consumers).
Both firms pay ad valorem output tax to consumers.
}
\examples{
\donttest{
dst.consumer1 <- node_set("utility", NA,
  type = "CD",
  alpha = 1,
  beta = c(0.3, 0.7),
  "prod1", "prod2"
)

dst.consumer2 <- Clone(dst.consumer1)
dst.consumer2$beta <- c(0.6, 0.4)

dst.firm1 <- node_set("output", NA,
  type = "Leontief",
  a = c(0.5, 0.2, 0.3),
  "VA", "prod1", "prod2"
)
node_set(dst.firm1, "VA",
  type = "CD",
  alpha = 0.8^-0.8 * 0.2^-0.2,
  beta = c(0.8, 0.2),
  "lab", "cap"
)

dst.firm2 <- Clone(dst.firm1)
node_set(dst.firm2, "output",
  a = c(0.25, 0.5, 0.25)
)
node_set(dst.firm2, "VA",
  alpha = 0.4^-0.4 * 0.6^-0.6,
  beta = c(0.4, 0.6)
)

## no taxation
dstl <- list(dst.firm1, dst.firm2, dst.consumer1, dst.consumer2)
ge <- gemTax_5_4(dstl, delta = 1)

## ad valorem output tax (see Table 4.1)
output.tax.rate <- 0.1
dst.taxed.firm1 <- node_set("taxed.output", NA,
  type = "FIN",
  rate = c(1, output.tax.rate),
  dst.firm1, "tax"
)
dst_plot(dst.taxed.firm1)

dst.taxed.firm2 <- node_set("taxed.output", NA,
  type = "FIN",
  rate = c(1, output.tax.rate),
  dst.firm2, "tax"
)
dst_plot(dst.taxed.firm2)

dstl <- list(dst.taxed.firm1, dst.taxed.firm2, dst.consumer1, dst.consumer2)

ge.output.tax1 <- gemTax_5_4(dstl, delta = 1)
ge.output.tax2 <- gemTax_5_4(dstl, delta = 0.5)
ge.output.tax3 <- gemTax_5_4(dstl, delta = 0)

## labor tax (see Table 4.3)
lab.tax.rate <- 0.1

dst.taxed.lab <- node_set("taxed.lab", NA,
  type = "FIN",
  rate = c(1, lab.tax.rate),
  "lab",
  "tax"
)

dst.labor.taxed.firm1 <- Clone(dst.firm1)
node_prune(dst.labor.taxed.firm1, "lab", "cap")
node_set(
  dst.labor.taxed.firm1, "VA",
  dst.taxed.lab,
  "cap"
)

dst.labor.taxed.firm2 <- Clone(dst.labor.taxed.firm1)
node_set(dst.labor.taxed.firm2, "output",
  a = c(0.25, 0.5, 0.25)
)
node_set(dst.labor.taxed.firm2, "VA",
  alpha = 0.4^-0.4 * 0.6^-0.6,
  beta = c(0.4, 0.6)
)

dstl <- list(dst.labor.taxed.firm1, dst.labor.taxed.firm2, dst.consumer1, dst.consumer2)

ge.lab.tax <- gemTax_5_4(dstl, delta = 0.5)

ge.lab.tax$p / ge$p
ge.lab.tax$z / ge$z - 1

## income tax (see Table 4.3)
income.tax.rate <- 0.2
consumption.tax.rate <- income.tax.rate / (1 - income.tax.rate)
dst.taxed.consumer1 <- node_set("tax.consumer", NA,
                                type = "FIN",
                                rate = c(1, consumption.tax.rate),
                                dst.consumer1,
                                "tax"
)

dst.taxed.consumer2 <- node_set("tax.consumer", NA,
                                type = "FIN",
                                rate = c(1, consumption.tax.rate),
                                dst.consumer2,
                                "tax"
)

dstl <- list(dst.firm1, dst.firm2, dst.taxed.consumer1, dst.taxed.consumer2)

ge.income.tax <- gemTax_5_4(dstl, delta = 0.5)
ge.income.tax$z / ge$z - 1

## labor tax (see Table 4.3)
lab.tax.rate <- 0.3742
node_set(dst.labor.taxed.firm1, "taxed.lab",
         rate = c(1, lab.tax.rate)
)
node_set(dst.labor.taxed.firm2, "taxed.lab",
         rate = c(1, lab.tax.rate)
)

ge.lab.tax <- gemTax_5_4(list(
  dst.labor.taxed.firm1,
  dst.labor.taxed.firm2,
  dst.consumer1,
  dst.consumer2
), delta = 0.5)
ge.lab.tax$z / ge$z - 1
}
}
\references{
Manuel Alejandro Cardenete, Ana-Isabel Guerra, Ferran Sancho (2012, ISBN: 9783642247453) Applied General Equilibrium: An Introduction. Springer-Verlag Berlin Heidelberg.
}
