% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.p.R
\name{var.p}
\alias{var.p}
\alias{sd.p}
\title{Population Variance and Population Standard Deviation}
\usage{
var.p(x, w = rep(1, length(x)), na.rm = FALSE)

sd.p(x, w = rep(1, length(x)), na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector.}

\item{w}{a numeric vector of weights.
By default all elements of x are given the same weight.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}
}
\description{
The function var.p computes a population variance. The function sd.p computes a population standard deviation.
}
\section{Functions}{
\itemize{
\item \code{var.p}: Population variance.

\item \code{sd.p}: Population standard deviation.
}}

\examples{
var.p(1:6)

var.p(x = 1:5, w = 6:10)
var.p(x = rep(1:5, 6:10))

sd.p(x = 1:5, w = 6:10)
sd.p(x = rep(1:5, 6:10))

}
