% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GENEActiv.calibrate.r
\name{GENEActiv.calibrate}
\alias{GENEActiv.calibrate}
\title{GENEActiv.calibrate}
\usage{
GENEActiv.calibrate(binfile, use.temp = TRUE, spherecrit = 0.3,
  minloadcrit = 72, printsummary = TRUE, chunksize = c(),
  windowsizes = c(5, 900, 3600))
}
\arguments{
\item{binfile}{A filename of a file to process.}

\item{use.temp}{use temperature sensor data for calibration}

\item{spherecrit}{The minimum required acceleration value (in g) on both sides of 0 g for each axis.
Used to judge whether the sphere is sufficiently populated}

\item{minloadcrit}{The minimum number of hours the code needs to read for the autocalibration procedure
to be effective (only sensitive to multitudes of 12 hrs, other values will be ceiled).
After loading these hours only extra data is loaded if calibration error has not been reduced to under 0.01 g}

\item{printsummary}{if TRUE will print a summary when done}

\item{chunksize}{number between 0.2 and 1 to specificy the size of chunks to be loaded as a fraction
of a 12 hour period, e.g. 0.5 equals 6 hour chunks. The default is 1 (12 hrs).
For machines with less than 4Gb of RAM memory a value below 1 is recommended.}

\item{windowsizes}{Three values to indicate the lengths of the windows as in c(window1,window2,window3):
window1 is the short epoch length in seconds and by default 5 this is the time window over which
acceleration and angle metrics are calculated, window2 is the long epoch length in seconds for which
non-wear and signal clipping are defined, default 900. However, window3 is the window length of data used
for non-wear detection and by default 3600 seconds. So, when window3 is larger than window2 we use
overlapping windows, while if window2 equals window3 non-wear periods are assessed by non-overlapping
windows.}
}
\description{
Function starts by identifying ten second windows of non-movement.
Next, the average acceleration per axis per window is used to estimate calibration error
(offset and scaling) per axis. The function provides recommended correction factors to address
the calibration error and a summary of the callibration procedure.
}
\details{


The outputs from the function are as follows \itemize{
\item scale scaling correction values, e.g. c(1,1,1)
\item offset offset correction values, e.g. c(0,0,0)
\item tempoffset correction values related to temperature, e.g. c(0,0,0)
\item cal.error.start absolute difference between Euclidean norm during all non-movement windows and 1 g before autocalibration
\item cal.error.end absolute difference between Euclidean norm during all non-movement windows and 1 g after autocalibration
\item spheredata average, standard deviation, Euclidean norm and temperature (if available) for all ten second non-movement windows as used for the autocalibration procedure
\item npoints number of 10 second no-movement windows used to populate the sphere
\item nhoursused number of hours of measurement data scanned to find the ten second time windows with no movement
\item meantempcal mean temperature corresponding to the data as used for autocalibration.
}
}
\references{
van Hees VT, Fang Z, Langford J, Assah F, Mohammad A, da Silva IC, Trenell MI, White T,
Wareham NJ, Brage S. Auto-calibration of accelerometer data for free-living physical activity assessment
using local gravity and temperature: an evaluation on four continents. J Appl Physiol (1985). 2014 Aug 7
}
\author{
Vincent T van Hees <vincentvanhees@gmail.com>
Zhou Fang
Charles Sweetland <charles@Sweetland-solutions.co.uk>
}
