% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_localcor.r
\name{GET.localcor}
\alias{GET.localcor}
\title{The test of local correlations}
\usage{
GET.localcor(
  data,
  Delta,
  nsim = 1000,
  typeone = c("fdr", "fwer"),
  varying.bandwidth = FALSE,
  bandwidth.nn = 0.1,
  bandwidth.h = 5.281,
  maxk = 300,
  savefuns = FALSE,
  N_s = 1000,
  mc.cores = 1L,
  mc.args = NULL,
  cl = NULL,
  notest = FALSE,
  ...
)
}
\arguments{
\item{data}{A data.frame where the first two columns correspond to the values of the two random fields,
whose correlations are to be studied, and the third and fourth columns correspond to the x- and y-coordinates
where these random fields have been observed. In addition, the width and height of the pixels at each (x,y)
can be given in the fifth and sixth column. Warning: no checks for the data input.}

\item{Delta}{A smoothing parameter of the local correlation.
According to Vilodomat et al. (2014): Delta is a set of values for the proportion of neighbors
to consider for the smoothing step. No default. The user may have to experiment with different
values to find one suitable for their data.}

\item{nsim}{The number of resamples.}

\item{typeone}{Character string indicating which type I error rate to control,
either the familywise error rate ('fwer') or false discovery rate ('fdr').
Further arguments to the FWER or FDR envelope can be passed in argument \code{GET.args}.
If 'fwer', the type of the envelope can be chosen by specifying the argument \code{type}
in \code{GET.args}.}

\item{varying.bandwidth}{Logical, whether to use a varying bandwidth to calculate the local correlations or not.
See Vilodomat et al. (2014).}

\item{bandwidth.nn}{Nearest neighbor component of the smoothing parameter for varying bandwidth to
be passed to the argument \code{nn} of the function \code{lp} of the \pkg{locfit} package.
The user may have to experiment with different values to find one suitable for their data.
Default set to to 0.1 according to Vilodamat et al. (2014, supporting information).}

\item{bandwidth.h}{Non-varying bandwidth, to be passed to the argument \code{h} of
the function \code{lp} of \pkg{locfit}.
The user may have to experiment with different values to find one suitable for their data.
Default to 5.281 according to Vilodamat et al. (2014, supporting information).}

\item{maxk}{See \code{locfit} and \code{locfit.raw} of \pkg{locfit}. Default here to 300
following Vilodomat et al. (2014).}

\item{savefuns}{Logical. If TRUE, then the functions from permutations are saved to the attribute
simfuns.}

\item{N_s}{If the number of observations is bigger than \code{N_s}, following Vilodomat et al. (2014)
a subsample of size N_s is taken every time when a variogram is calculated.}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously.
Must be at least one, and parallelization requires at least two cores. On a Windows computer mc.cores must be 1
(no parallelization). For details, see \code{\link{mclapply}}, for which the argument is passed.
Parallelization can be used in generating simulations and in calculating the second stage tests.}

\item{mc.args}{A named list of additional arguments to be passed to \code{\link{mclapply}}.
Only relevant if \code{mc.cores} is more than 1.}

\item{cl}{Allows parallelization through the use of \code{\link{parLapply}} (works also
in Windows), see the argument \code{cl} there, and examples.}

\item{notest}{Logical. FALSE means that the test is done. TRUE allows to calculate only local
correlation for the data, which can be beneficial for choosing the bandwidths before running
the test. If TRUE, then only the observed local correlations will be returned.}

\item{...}{Additional parameters to be passed to \code{\link{fdr_envelope}} (if typeone = "fdr") or
to \code{\link{global_envelope_test}} (if typeone = "fwer").}
}
\value{
A global envelope object (with possible additional classes), see description of main components 
in \code{\link{global_envelope}} (Value).
Additional attributes: \code{p_global} contains the Monte Carlo p-value for the global test of correlation.
\code{cor_global} and \code{cor_global_sim} contain the value of the correlation for data and permuted data,
respectively. If \code{savefuns = TRUE}, then \code{permutations} contain the permuted values of the first
random field according to Viladomat et al. (2014) procedure, and \code{cset} contains all the local correlations
for the data and permuted data in a \code{curve_set} object (see \code{\link{create_curve_set}}).
}
\description{
The test of local correlations using Vilodomat et al. (2014) procedure for resamples
and the FDR envelope of Mrkvička and Myllymäki (2022).
}
\details{
The code is a modification of the supporting information code of Vilodomat et al. (2014)
available at https://doi.org/10.1111/biom.12139. The modification includes the FDR (or FWER,
if specified by the argument \code{typeone}) envelopes for the test of local correlations,
i.e. multiple testing correction and graphical illustration of the test results.

Variograms are calculated using the package \pkg{geoR} and the local correlations using the R
package \pkg{locfit}. These packages should be installed to use \code{GET.localcor}.

Currently the data is provided in the format of Vilodomat et al. (2014, Supporting information).
Additionally width and height of area represented by a data point can be provided, see the argument \code{data}.
This information is used for plotting purposes when plotting the output by \code{plot()}.

Examples will be provided in a vignette.
}
\references{
Viladomat, J., Mazumder, R., McInturff, A., McCauley, D.J. and Hastie, T. (2014). Assessing the significance of global and local correlations under spatial autocorrelation: A nonparametric approach. Biometrics 70, 409-418. doi: 10.1111/biom.12139

Mrkvička and Myllymäki (2022). False discovery rate envelopes. arXiv:2008.10108 [stat.ME]
}
