% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Depmeasure.GFGM.R
\name{Dependence.GFGM}
\alias{Dependence.GFGM}
\title{Bivariate dependence measures under the generalized FGM copula}
\usage{
Dependence.GFGM(p, q, theta)
}
\arguments{
\item{p}{Copula parameter that greater than or equal to 1.}

\item{q}{Copula parameter that greater than 1.}

\item{theta}{Copula parameter with restricted range.}
}
\value{
\item{theta}{Dependence parameter.}
\item{tau}{Kendall's tau.}
\item{rho}{Spearman's rho.}
}
\description{
Compute Kendall's tau and Spearman's rho with their boundaries under the generalized FGM copula.
}
\details{
The admissiable range of \code{theta} (\eqn{\theta}) is
\deqn{-\min\bigg\{1,\frac{1}{p^{2q}}\bigg(\frac{1+pq}{q-1}\bigg)^{2q-2}\bigg\} \leq \theta \leq \frac{1}{p^{q}}\bigg(\frac{1+pq}{q-1}\bigg)^{q-1}.}
See also Shih and Emura (2016) for details.
}
\examples{
library(GFGM.copula)
Dependence.GFGM(3,2,0.75)
}
\references{
Shih and Emura (2016) Bivariate dependence measures and bivariate competing risks models under the generalized FGM copula, Statistical Papers, doi: 10.1007/s00362-016-0865-5.
}
