% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FORCE.R
\name{gforce.defaults}
\alias{gforce.defaults}
\title{FORCE default tuning parameters.}
\usage{
gforce.defaults(d)
}
\arguments{
\item{d}{dimension of random vector or number of datapoints.}
}
\value{
An object with following components
\describe{
\item{\code{adapt_init_mode}}{a numeric. Indicates which initialization mode to use for \code{\link{gforce.FORCE_adapt}}.}
\item{\code{alpha}}{a numeric. Gives the step size for the projected gradient descent updates.}
\item{\code{dual_frequency}}{an integer. Specifies how many gradient updates to perform between searches for a dual certificate. }
\item{\code{duality_gap}}{a numeric. If the duality gap can be shown to be less than \code{duality_gap}, the FORCE algorithm terminates.}
\item{\code{early_stop_mode}}{a numeric. \code{early_stop_mode == 1} indicates that the algorithm should use an early stopping rule.}
\item{\code{early_stop_lag}}{an integer. This indicates the number of iterations without sufficient improvement in objective value before early stopping.}
\item{\code{early_stop_eps}}{a numeric. Threshold for objective value improvement used to determine early stopping.}
\item{\code{eps_obj}}{a numeric. Specifies the precision required of the optimal solution to the eigenvalue maximization problem.}
\item{\code{finish_pgd}}{an integer. If \code{finish_pgd} is 1, then other stopping criteria are ignored and FORCE performs \code{max_iter} gradient updates.}
\item{\code{initial_mixing}}{a numeric between 0 and 1. Specifies how to construct the initial strictly feasible solution to the SDP relaxation.}
\item{\code{kmeans_iter}}{an integer. The number of times to run a \eqn{K}-means solver during each search for an optimal clustering and dual certificate.}
\item{\code{max_iter}}{an integer. The maximum number of gradient updates to perform.}
\item{\code{primal_only}}{an integer. \code{primal_only == 1} indicates that the algorithm should not search for a dual certificate.}
\item{\code{restarts}}{a vector of integers. This specifies the iterations at which to take the projection of the current iterate and restart the algorithm with that as the initial solution.}
\item{\code{verbose}}{an integer. Specifies the level of verbosity requested from gforce.FORCE.}
}
}
\description{
Provides the default tuning parameters for \code{\link{gforce.FORCE}}.
}
\examples{
opts <- gforce.defaults(20)
}
