% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.ggmncv.R
\name{coef.ggmncv}
\alias{coef.ggmncv}
\title{Regression Coefficients from \code{ggmncv} Objects}
\usage{
\method{coef}{ggmncv}(object, ...)
}
\arguments{
\item{object}{An Object of class \code{ggmncv}.}

\item{...}{Currently ignored.}
}
\value{
A matrix of regression coefficients.
}
\description{
There is a direct correspondence between the inverse covariance
matrix and multiple regression \insertCite{stephens1998,kwan2014regression}{GGMncv}.
This readily allows for converting the off diagonal elements to regression coefficients,
resulting in noncovex penalization for multiple regression modeling.
}
\note{
The coefficients can be accessed via \code{coefs[1,]},
which provides the estimates for predicting the first node.

Further, the estimates are essentially computed with both
the outcome and predictors scaled to have mean 0 and
standard deviation 1.
}
\examples{

\donttest{

# data
Y <- GGMncv::ptsd[,1:5]

# correlations
S <- cor(Y)

# fit model
fit <- ggmncv(R = S, n = nrow(Y), progress = FALSE)

# regression
coefs <- coef(fit)

coefs


# no regularization, resulting in OLS

# data
# note: scaled for lm()
Y <- scale(GGMncv::ptsd[,1:5])

# correlations
S <- cor(Y)

# fit model
# note: non reg
fit <- ggmncv(R = S, n = nrow(Y), progress = FALSE, lambda = 0)

# regression
coefs <- coef(fit)

# fit lm
fit_lm <- lm(Y[,1] ~ 0 + Y[,-1])

# ggmncv
coefs[1,]

# lm
as.numeric(coef(fit_lm))

}

}
\references{
\insertAllCited{}
}
