% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{inference}
\alias{inference}
\alias{significance_test}
\title{Statistical Inference for Regularized Gaussian Graphical Models}
\usage{
inference(object, method = "fdr", alpha = 0.05, ...)

significance_test(object, method = "fdr", alpha = 0.05, ...)
}
\arguments{
\item{object}{An object of class \code{ggmncv}}

\item{method}{Character string. A correction method for multiple comparison (defaults to \code{fdr}).
Can be abbreviated. See \link[stats]{p.adjust}.}

\item{alpha}{Numeric. Significance level (defaults to \code{0.05}).}

\item{...}{Currently ignored.}
}
\value{
\itemize{

\item \code{Theta} De-sparsified precision matrix

\item \code{adj} Adjacency matrix based on the p-values.

\item \code{pval_uncorrected} Uncorrected p-values

\item \code{pval_corrected} Corrected p-values

\item \code{method} The approach used for multiple comparisons

\item \code{alpha} Significance level
}
}
\description{
Compute \emph{p}-values for each relation based on the
de-sparsified glasso estimator \insertCite{jankova2015confidence}{GGMncv}.
}
\note{
This assumes (reasonably) Gaussian data, and should not to be expected
to work for, say, polychoric correlations. Further, all work to date
has only looked at the graphical lasso estimator, and not de-sparsifying
nonconvex regularization. Accordingly, it is probably best to set
\code{penalty = "lasso"} in \code{\link{ggmncv}}.

Further, whether the de-sparsified estimator provides nominal error rates
remains to be seen, at least across a range of conditions. For example,
the simulation results in \insertCite{williams_2021;textual}{GGMncv}
demonstrated that the confidence intervals
can have (severely) compromised coverage properties (whereas non-regularized methods
had coverage at the nominal level).
}
\examples{
# data
Y <- GGMncv::ptsd[,1:5]

# fit model
fit <- ggmncv(cor(Y), n = nrow(Y),
              progress = FALSE,
              penalty = "lasso")


# statistical inference
inference(fit)

# alias
all.equal(inference(fit), significance_test(fit))

}
\references{
\insertAllCited{}
}
