% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_search.R
\name{mixed_search}
\alias{mixed_search}
\title{Mixed Graphical Model: automated search}
\usage{
mixed_search(Y, data_type = NULL, IC = "BIC")
}
\arguments{
\item{Y}{A data matrix of dimensions \emph{n} (observations) by \emph{p} (nodes)}

\item{data_type}{Vector of length \emph{p}. The type of data, with options of
"b" (binary), "p" (Poisson), and "g" (Gaussian).}

\item{IC}{Character string. The desired information criterion. Options include
\code{"AIC"} and \code{"BIC"} (default).}
}
\value{
An object of class \code{mixed_search}, including \code{wadj} (weighted adjacency matrix)
        and \code{adj} (adjacency matrix).
}
\description{
Data mining to learn the graph.
}
\details{
Only backwards selection is currently implemented.
         Only an adjacency matrix is provided.
}
\examples{
\donttest{
# data
Y <- ifelse( ptsd[,1:5] == 0, 0, 1)

# search data (ising model)
fit <- mixed_search(Y, data_type = rep("b", 5))
}
}
