% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.ggpairs}
\alias{print.ggpairs}
\title{Print ggpair object}
\usage{
\method{print}{ggpairs}(x, leftWidthProportion = 0.2,
  bottomHeightProportion = 0.1, spacingProportion = 0.03,
  showStrips = NULL, ...)
}
\arguments{
\item{x}{ggpair object to be plotted}

\item{...}{not used}
}
\description{
Specialized method to print the ggpair object-
}
\examples{
data(tips, package = "reshape")
 pMat <- ggpairs(tips, c(1,3,2), color = "sex")
 pMat # calls print(pMat), which calls print.ggpairs(pMat)

 ## defaults; (prints strips on top and right edges of matrix)
 # print(pMat, left = 0.2, spacing = 0.03, bottom = 0.1, showStrips = NULL)

 ## show none of the strips
 # print(pMat, showStrips = FALSE)

 ## show all of the strips
 # print(pMat, showStrips = TRUE)

 ## give the left axis labels area a proportion of 3 plot size
 # print(pMat, leftWidthProportion = 3)

 ## give the bottom axis labels area a proportion of 1 plot size
 # print(pMat, bottomHeightProportion = 1)

 ## give the spacing between plots a proportion of 1 plot size
 # print(pMat, spacing = 1)
}
\author{
Barret Schloerke \email{schloerke@gmail.com}
}
\keyword{internal}

