% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnostic.R
\name{ggally_nostic_cooksd}
\alias{ggally_nostic_cooksd}
\title{ggnostic - Cook's distance}
\usage{
ggally_nostic_cooksd(data, mapping, ..., linePosition = 4/nrow(data),
  lineColor = brew_colors("grey"), lineType = 2)
}
\arguments{
\item{data, mapping, ..., lineColor, lineType}{parameters supplied to \code{\link{ggally_nostic_line}}}

\item{linePosition}{4 / n is the general cutoff point for Cook's Distance}
}
\value{
ggplot2 plot object
}
\description{
A function to display \code{stats::\link[stats]{cooks.distance}}.
}
\details{
A line is added at 4 / n to display the general cutoff point for Cook's Distance.

Reference: Cook, R. Dennis; Weisberg, Sanford (1982). Residuals and Influence in Regression. New York, NY: Chapman & Hall. ISBN 0-412-24280-X
}
\examples{
dt <- broomify(stats::lm(mpg ~ wt + qsec + am, data = mtcars))
ggally_nostic_cooksd(dt, ggplot2::aes(wt, .cooksd))
}
\seealso{
\code{stats::\link[stats]{cooks.distance}}
}

