% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_cross.R
\name{ggally_crosstable}
\alias{ggally_crosstable}
\title{Display a cross-tabulated table}
\usage{
ggally_crosstable(
  data,
  mapping,
  cells = c("observed", "prop", "row.prop", "col.prop", "expected", "residuals",
    "stdres"),
  fill = c("none", "stdres", "residuals"),
  ...,
  geom_tile_args = list(colour = "grey50")
)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{cells}{Which statistic should be displayed in table cells?}

\item{fill}{Which statistic should be used for filling table cells?}

\item{...}{other arguments passed to \code{\link[ggplot2]{geom_text}(...)}}

\item{geom_tile_args}{other arguments passed to \code{\link[ggplot2]{geom_tile}(...)}}
}
\description{
\code{ggally_crosstable} is a variation of \code{\link{ggally_table}} with few modifications: (i) table cells are drawn; (ii) x and y axis are not expanded (and therefore are not aligned with other \code{ggally_*} plots); (iii) content and fill of cells can be easily controlled with dedicated arguments.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips, package = "reshape")

# differences with ggally_table()
p_(ggally_table(tips, mapping = aes(x = day, y = time)))
p_(ggally_crosstable(tips, mapping = aes(x = day, y = time)))

# display column proportions
p_(ggally_crosstable(tips, mapping = aes(x = day, y = sex), cells = "col.prop"))

# display row proportions
p_(ggally_crosstable(tips, mapping = aes(x = day, y = sex), cells = "row.prop"))

# change size of text
p_(ggally_crosstable(tips, mapping = aes(x = day, y = sex), size = 8))

# fill cells with standardized residuals
p_(ggally_crosstable(tips, mapping = aes(x = day, y = sex), fill = "stdres"))

# change scale for fill
p_(ggally_crosstable(tips, mapping = aes(x = day, y = sex), fill = "stdres") +
  scale_fill_steps2(breaks = c(-2, 0, 2), show.limits = TRUE))
}
