% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_dot}
\alias{ggally_dot}
\alias{ggally_dot_no_facet}
\title{Grouped dot plot}
\usage{
ggally_dot(data, mapping, ...)

ggally_dot_no_facet(data, mapping, ...)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments being supplied to geom_jitter}
}
\description{
Add jittering with the box plot. \code{ggally_dot_no_facet} will be a single panel plot, while \code{ggally_dot} will be a faceted plot
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips, package = "reshape")
p_(ggally_dot(tips, mapping = ggplot2::aes(x = total_bill, y = sex)))
p_(ggally_dot(tips, mapping = ggplot2::aes_string(x = "total_bill", y = "sex")))
p_(ggally_dot(
  tips,
  mapping = ggplot2::aes_string(y = "total_bill", x = "sex", color = "sex")
))
p_(ggally_dot(
  tips,
  mapping = ggplot2::aes_string(y = "total_bill", x = "sex", color = "sex", shape = "sex")
) + ggplot2::scale_shape(solid=FALSE))
}
\author{
Barret Schloerke
}
\keyword{hplot}
