% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMcatMethods.R
\name{coef.glmcat}
\alias{coef.glmcat}
\title{Model coefficients}
\usage{
\method{coef}{glmcat}(object, na.rm = FALSE, ...)
}
\arguments{
\item{object}{a GLMcat model.}

\item{na.rm}{TRUE for NA coefficients to be removed, default is FALSE.}

\item{...}{other arguments.}
}
\description{
Extract model coefficients from a glmcat object.
}
\examples{
data(DisturbedDreams)
mod1 <- GLMcat(
  formula = Level ~ Age,
  ref_category = "Very.severe",
  data = DisturbedDreams, distribution = "logistic"
)
coef(mod1)
}
