% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgamma.rp.r
\name{Reparameterized.gamma}
\alias{Reparameterized.gamma}
\alias{dgamma.rp}
\alias{pgamma.rp}
\alias{qgamma.rp}
\alias{rgamma.rp}
\title{Reparameterized Gamma distribution functions}
\usage{
dgamma.rp(x, mean, var, log = FALSE)

pgamma.rp(q, mean, var, lower.tail = TRUE, log.p = FALSE)

qgamma.rp(p, mean, var, lower.tail = TRUE, log.p = FALSE)

rgamma.rp(n, mean, var)
}
\arguments{
\item{x}{likelihood function evaluates at point x}

\item{mean}{mean}

\item{var}{variance}

\item{log}{as in stats::*gamma}

\item{q}{quantile}

\item{lower.tail}{logical; if TRUE (default), probabilities are P(X < x), otherwise, P(X>x).}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{p}{cumulative probability}

\item{n}{sample size}
}
\value{
Returns density values, cumulative probabilities, quantiles and random samples from a gamma distribution.
}
\description{
Reparameterized Gamma distribution functions
}
\examples{
dgamma.rp(1, 1, 1)
pgamma.rp(1.96, 1, 1)
qgamma.rp(.975, 1, 1)
rgamma.rp(10, 1, 1)
}
