% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ss.bin.int.req.r
\name{return.ss.bin.int.req}
\alias{return.ss.bin.int.req}
\title{Return single sample binary predictive probability}
\usage{
return.ss.bin.int.req(
  a.trt = 1,
  b.trt = 1,
  Delta.lrv = 0.2,
  Delta.tv = 0.35,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  interim.n.t = c(0:39),
  final.n.t = 40,
  p.success = 0.5,
  x.ng = NULL,
  x.go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8
)
}
\arguments{
\item{a.trt}{prior alpha parameter}

\item{b.trt}{prior beta parameter}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{interim.n.t}{number of trials at interim}

\item{final.n.t}{number of trials at final}

\item{p.success}{probability of success}

\item{x.ng}{responses for go; leave null for standard rule}

\item{x.go}{responses for go; leave null for standard rule}

\item{go.thresh}{go threshold for predictive probability at interim}

\item{ng.thresh}{no-go threshold for predictive probability at interim}
}
\value{
Return single sample binary predictive probability
}
\description{
Return single sample binary predictive probability
}
\examples{
holdit <- return.ss.bin.int.req()
head(holdit)
}
