% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.tte.int.data.req.r
\name{return.tte.int.data.req}
\alias{return.tte.int.data.req}
\title{Title}
\usage{
return.tte.int.data.req(
  m.con.prior = 0.001,
  m.trt.prior = 0.001,
  HR.prior = 1,
  ARatio = 1,
  interim.HR = c(0.8, 0.7, 0.65, 0.68, 0.7),
  interim.m = c(100, 200, 300, 400, 750),
  final.m = 1000,
  HR.tv = 0.7,
  HR.lrv = 0.9,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  HR.ng = NULL,
  HR.go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8,
  include_nogo = TRUE
)
}
\arguments{
\item{m.con.prior}{prior number of control events}

\item{m.trt.prior}{prior number of treatment events}

\item{HR.prior}{prior estimate for HR}

\item{ARatio}{randomization ratio}

\item{interim.HR}{Interim HR}

\item{interim.m}{Interim events}

\item{final.m}{final events}

\item{HR.tv}{TPP Target Value aka Base TPP}

\item{HR.lrv}{TPP Lower Reference Value aka Max TPP (large HRs lead to No-Go)}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{HR.ng}{HR needed for ng; leave null for standard rule}

\item{HR.go}{HR needed for go; leave null for standard rule}

\item{go.thresh}{go threshold for predictive probability}

\item{ng.thresh}{no-go threshold for predictive probability}

\item{include_nogo}{logical}
}
\value{
A data.frame is returned
}
\description{
Title
}
\examples{
\donttest{
holdit <- return.tte.int.data.req()
head(holdit)
}
}
