% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistCC.R
\name{GOTermCC2ChildLevel}
\alias{GOTermCC2ChildLevel}
\title{Get the level of a cellular component (CC) GO term's children}
\usage{
GOTermCC2ChildLevel(goterm)
}
\arguments{
\item{goterm}{A character string of a valid gene ontology id e.g "GO:0005737"}
}
\value{
A list of children terms and their respective levels
}
\description{
This function retrieves a GO CC term children's level i.e. for a GO-term it's children level are derived.
}
\examples{
# Retrieve "GO:0005737" children's level
GOTermCC2ChildLevel("GO:0005737")

# Retrieve "GO:0099568" children's level
GOTermCC2ChildLevel("GO:0099568")
}
